/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class BrachaTouegDeadlockMessage
implements Writable {
    public static final long NOTIFY = 1L;
    public static final long GRANT = 2L;
    public static final long ACK = 4L;
    public static final long DONE = 8L;
    public static final long CTRL_IN_EDGE = 16L;
    private long senderId;
    private long type;

    public BrachaTouegDeadlockMessage() {
    }

    public BrachaTouegDeadlockMessage(long id, long type) {
        this.senderId = id;
        this.type = type;
    }

    public void readFields(DataInput input) throws IOException {
        this.senderId = input.readLong();
        this.type = input.readLong();
    }

    public void write(DataOutput output) throws IOException {
        output.writeLong(this.senderId);
        output.writeLong(this.type);
    }

    public long getSenderId() {
        return this.senderId;
    }

    public long getType() {
        return this.type;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Message ");
        buffer.append("{ sender: " + this.senderId + "; type: ");
        if (this.type == 1L) {
            buffer.append("notify");
        } else if (this.type == 2L) {
            buffer.append("grant");
        } else if (this.type == 4L) {
            buffer.append("ack");
        } else if (this.type == 8L) {
            buffer.append("done");
        } else if (this.type == 16L) {
            buffer.append("<ctrl>");
        } else {
            buffer.append("unknown");
        }
        buffer.append(" }");
        return buffer.toString();
    }
}

