/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples.scc;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.io.Writable;

public class SccVertexValue
implements Writable {
    private LongArrayList parents;
    private long value = Long.MIN_VALUE;
    private boolean active = true;

    public SccVertexValue() {
    }

    public SccVertexValue(long value) {
        this.value = value;
    }

    public void readFields(DataInput in) throws IOException {
        this.value = in.readLong();
        int size = in.readInt();
        if (size != 0) {
            for (int i = 0; i < size; ++i) {
                this.addParent(in.readLong());
            }
        }
        this.active = in.readBoolean();
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.value);
        int size = this.parents == null ? 0 : this.parents.size();
        out.writeInt(size);
        if (size != 0) {
            Iterator i$ = this.parents.iterator();
            while (i$.hasNext()) {
                long incomingId = (Long)i$.next();
                out.writeLong(incomingId);
            }
        }
        out.writeBoolean(this.active);
    }

    public LongArrayList getParents() {
        return this.parents;
    }

    public void addParent(long vertexId) {
        if (this.parents == null) {
            this.parents = new LongArrayList();
        }
        this.parents.add(vertexId);
    }

    public void clearParents() {
        this.parents = null;
    }

    public void set(long value) {
        this.value = value;
    }

    public long get() {
        return this.value;
    }

    public void deactivate() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

