/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples.scc;

import org.apache.giraph.aggregators.BooleanOverwriteAggregator;
import org.apache.giraph.aggregators.IntOverwriteAggregator;
import org.apache.giraph.master.DefaultMasterCompute;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;

public class SccPhaseMasterCompute
extends DefaultMasterCompute {
    public static final String PHASE = "scccompute.phase";
    public static final String NEW_MAXIMUM = "scccompute.max";
    public static final String CONVERGED = "scccompute.converged";

    public void initialize() throws InstantiationException, IllegalAccessException {
        this.registerPersistentAggregator(PHASE, IntOverwriteAggregator.class);
        this.registerAggregator(NEW_MAXIMUM, BooleanOverwriteAggregator.class);
        this.registerAggregator(CONVERGED, BooleanOverwriteAggregator.class);
    }

    public void compute() {
        if (this.getSuperstep() == 0L) {
            this.setPhase(Phases.TRANSPOSE);
        } else {
            Phases currPhase = this.getPhase();
            switch (currPhase) {
                case TRANSPOSE: {
                    this.setPhase(Phases.TRIMMING);
                    break;
                }
                case TRIMMING: {
                    this.setPhase(Phases.FORWARD_TRAVERSAL);
                    break;
                }
                case FORWARD_TRAVERSAL: {
                    BooleanWritable newMaxFound = (BooleanWritable)this.getAggregatedValue(NEW_MAXIMUM);
                    if (newMaxFound.get()) break;
                    this.setPhase(Phases.BACKWARD_TRAVERSAL_START);
                    break;
                }
                case BACKWARD_TRAVERSAL_START: {
                    this.setPhase(Phases.BACKWARD_TRAVERSAL_REST);
                    break;
                }
                case BACKWARD_TRAVERSAL_REST: {
                    BooleanWritable converged = (BooleanWritable)this.getAggregatedValue(CONVERGED);
                    if (converged.get()) break;
                    this.setPhase(Phases.TRANSPOSE);
                    break;
                }
            }
        }
    }

    private void setPhase(Phases phase) {
        this.setAggregatedValue(PHASE, (Writable)new IntWritable(phase.ordinal()));
    }

    private Phases getPhase() {
        IntWritable phaseInt = (IntWritable)this.getAggregatedValue(PHASE);
        return SccPhaseMasterCompute.getPhase(phaseInt);
    }

    public static Phases getPhase(IntWritable phaseInt) {
        return Phases.values()[phaseInt.get()];
    }

    public static enum Phases {
        TRANSPOSE,
        TRIMMING,
        FORWARD_TRAVERSAL,
        BACKWARD_TRAVERSAL_START,
        BACKWARD_TRAVERSAL_REST;

    }
}

