/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples.scc;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.examples.scc.SccVertexValue;
import org.apache.giraph.io.formats.TextVertexInputFormat;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class SccLongLongNullTextInputFormat
extends TextVertexInputFormat<LongWritable, SccVertexValue, NullWritable> {
    private static final Pattern SEPARATOR = Pattern.compile("[\t ]");

    public TextVertexInputFormat.TextVertexReader createVertexReader(InputSplit split, TaskAttemptContext context) throws IOException {
        return new LongLongNullVertexReader();
    }

    public class LongLongNullVertexReader
    extends TextVertexInputFormat.TextVertexReaderFromEachLineProcessed<String[]> {
        private LongWritable id;

        public LongLongNullVertexReader() {
            super((TextVertexInputFormat)SccLongLongNullTextInputFormat.this);
        }

        protected String[] preprocessLine(Text line) throws IOException {
            String[] tokens = SEPARATOR.split(line.toString());
            this.id = new LongWritable(Long.parseLong(tokens[0]));
            return tokens;
        }

        protected LongWritable getId(String[] tokens) throws IOException {
            return this.id;
        }

        protected SccVertexValue getValue(String[] tokens) throws IOException {
            return new SccVertexValue(Long.parseLong(tokens[0]));
        }

        protected Iterable<Edge<LongWritable, NullWritable>> getEdges(String[] tokens) throws IOException {
            ArrayList edges = Lists.newArrayListWithCapacity((int)(tokens.length - 1));
            for (int n = 1; n < tokens.length; ++n) {
                edges.add(EdgeFactory.create((WritableComparable)new LongWritable(Long.parseLong(tokens[n]))));
            }
            return edges;
        }
    }
}

