/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples.scc;

import java.io.IOException;
import org.apache.giraph.Algorithm;
import org.apache.giraph.examples.scc.SccPhaseMasterCompute;
import org.apache.giraph.examples.scc.SccVertexValue;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

@Algorithm(name="Strongly Connected Components", description="Finds strongly connected components of the graph")
public class SccComputation
extends BasicComputation<LongWritable, SccVertexValue, NullWritable, LongWritable> {
    private SccPhaseMasterCompute.Phases currPhase;
    private LongWritable messageValue = new LongWritable();
    private LongWritable parentId = new LongWritable();

    public void preSuperstep() {
        IntWritable phaseInt = (IntWritable)this.getAggregatedValue("scccompute.phase");
        this.currPhase = SccPhaseMasterCompute.getPhase(phaseInt);
    }

    public void compute(Vertex<LongWritable, SccVertexValue, NullWritable> vertex, Iterable<LongWritable> messages) throws IOException {
        SccVertexValue vertexValue = (SccVertexValue)vertex.getValue();
        if (!vertexValue.isActive()) {
            vertex.voteToHalt();
            return;
        }
        switch (this.currPhase) {
            case TRANSPOSE: {
                vertexValue.clearParents();
                this.sendMessageToAllEdges(vertex, (Writable)vertex.getId());
                break;
            }
            case TRIMMING: {
                this.trim(vertex, messages);
                break;
            }
            case FORWARD_TRAVERSAL: {
                this.forwardTraversal(vertex, messages);
                break;
            }
            case BACKWARD_TRAVERSAL_START: {
                this.backwardTraversalStart(vertex);
                break;
            }
            case BACKWARD_TRAVERSAL_REST: {
                this.backwardTraversalRest(vertex, messages);
                break;
            }
        }
    }

    private void trim(Vertex<LongWritable, SccVertexValue, NullWritable> vertex, Iterable<LongWritable> messages) {
        SccVertexValue vertexValue = (SccVertexValue)vertex.getValue();
        for (LongWritable parent : messages) {
            vertexValue.addParent(parent.get());
        }
        vertexValue.set(((LongWritable)vertex.getId()).get());
        if (vertex.getNumEdges() == 0 || vertexValue.getParents() == null) {
            vertexValue.deactivate();
        } else {
            this.messageValue.set(vertexValue.get());
            this.sendMessageToAllEdges(vertex, (Writable)this.messageValue);
        }
    }

    private void forwardTraversal(Vertex<LongWritable, SccVertexValue, NullWritable> vertex, Iterable<LongWritable> messages) {
        SccVertexValue vertexValue = (SccVertexValue)vertex.getValue();
        boolean changed = this.setMaxValue(vertexValue, messages);
        if (changed) {
            this.messageValue.set(vertexValue.get());
            this.sendMessageToAllEdges(vertex, (Writable)this.messageValue);
            this.aggregate("scccompute.max", (Writable)new BooleanWritable(true));
        }
    }

    private void backwardTraversalStart(Vertex<LongWritable, SccVertexValue, NullWritable> vertex) {
        SccVertexValue vertexValue = (SccVertexValue)vertex.getValue();
        if (vertexValue.get() == ((LongWritable)vertex.getId()).get()) {
            this.messageValue.set(vertexValue.get());
            this.sendMessageToAllParents(vertex, this.messageValue);
        }
    }

    private void backwardTraversalRest(Vertex<LongWritable, SccVertexValue, NullWritable> vertex, Iterable<LongWritable> messages) {
        SccVertexValue vertexValue = (SccVertexValue)vertex.getValue();
        for (LongWritable m : messages) {
            if (vertexValue.get() != m.get()) continue;
            this.sendMessageToAllParents(vertex, m);
            this.aggregate("scccompute.converged", (Writable)new BooleanWritable(true));
            vertexValue.deactivate();
            vertex.voteToHalt();
            break;
        }
    }

    private boolean setMaxValue(SccVertexValue vertexValue, Iterable<LongWritable> messages) {
        boolean changed = false;
        for (LongWritable m : messages) {
            if (vertexValue.get() >= m.get()) continue;
            vertexValue.set(m.get());
            changed = true;
        }
        return changed;
    }

    private void sendMessageToAllParents(Vertex<LongWritable, SccVertexValue, NullWritable> vertex, LongWritable message) {
        for (Long id : ((SccVertexValue)vertex.getValue()).getParents()) {
            this.parentId.set(id.longValue());
            this.sendMessage((WritableComparable)this.parentId, (Writable)message);
        }
    }
}

