/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples.io.formats;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.examples.utils.BrachaTouegDeadlockVertexValue;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.formats.TextVertexInputFormat;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.json.JSONArray;
import org.json.JSONException;

public class BrachaTouegDeadlockInputFormat
extends TextVertexInputFormat<LongWritable, BrachaTouegDeadlockVertexValue, LongWritable> {
    public TextVertexInputFormat.TextVertexReader createVertexReader(InputSplit split, TaskAttemptContext context) {
        return new JsonLongLongLongLongVertexReader();
    }

    class JsonLongLongLongLongVertexReader
    extends TextVertexInputFormat.TextVertexReaderFromEachLineProcessedHandlingExceptions<JSONArray, JSONException> {
        JsonLongLongLongLongVertexReader() {
            super((TextVertexInputFormat)BrachaTouegDeadlockInputFormat.this);
        }

        protected JSONArray preprocessLine(Text line) throws JSONException {
            return new JSONArray(line.toString());
        }

        protected LongWritable getId(JSONArray jsonVertex) throws JSONException, IOException {
            return new LongWritable(jsonVertex.getLong(0));
        }

        protected BrachaTouegDeadlockVertexValue getValue(JSONArray jsonVertex) throws JSONException, IOException {
            return new BrachaTouegDeadlockVertexValue();
        }

        protected Iterable<Edge<LongWritable, LongWritable>> getEdges(JSONArray jsonVertex) throws JSONException, IOException {
            JSONArray jsonEdgeArray = jsonVertex.getJSONArray(1);
            ArrayList edges = Lists.newArrayListWithCapacity((int)jsonEdgeArray.length());
            for (int i = 0; i < jsonEdgeArray.length(); ++i) {
                JSONArray jsonEdge = jsonEdgeArray.getJSONArray(i);
                LongWritable targetId = new LongWritable(jsonEdge.getLong(0));
                LongWritable tag = new LongWritable(jsonEdge.getLong(1));
                edges.add(EdgeFactory.create((WritableComparable)targetId, (Writable)tag));
            }
            return edges;
        }

        protected Vertex<LongWritable, BrachaTouegDeadlockVertexValue, LongWritable> handleException(Text line, JSONArray jsonVertex, JSONException e) {
            throw new IllegalArgumentException("Couldn't get vertex from line " + line, (Throwable)e);
        }
    }
}

