/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.aggregators.LongSumAggregator;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.master.DefaultMasterCompute;
import org.apache.giraph.worker.WorkerContext;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

public class VerifyMessage {

    public static class VerifyMessageMasterCompute
    extends DefaultMasterCompute {
        public void initialize() throws InstantiationException, IllegalAccessException {
            this.registerAggregator(LongSumAggregator.class.getName(), LongSumAggregator.class);
        }
    }

    public static class VerifyMessageComputation
    extends BasicComputation<LongWritable, IntWritable, FloatWritable, VerifiableMessage> {
        public static final String SUPERSTEP_COUNT = "verifyMessageVertex.superstepCount";
        private static long FINAL_SUM;
        private static int SUPERSTEPS;
        private static Logger LOG;

        public static long getFinalSum() {
            return FINAL_SUM;
        }

        public void compute(Vertex<LongWritable, IntWritable, FloatWritable> vertex, Iterable<VerifiableMessage> messages) throws IOException {
            String sumAggregatorName = LongSumAggregator.class.getName();
            if (this.getSuperstep() > (long)SUPERSTEPS) {
                vertex.voteToHalt();
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("compute: " + this.getAggregatedValue(sumAggregatorName)));
            }
            this.aggregate(sumAggregatorName, (Writable)new LongWritable(((LongWritable)vertex.getId()).get()));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("compute: sum = " + ((LongWritable)this.getAggregatedValue(sumAggregatorName)).get() + " for vertex " + vertex.getId()));
            }
            float msgValue = 0.0f;
            for (VerifiableMessage message : messages) {
                msgValue += message.value;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("compute: got msg = " + message + " for vertex id " + vertex.getId() + ", vertex value " + vertex.getValue() + " on superstep " + this.getSuperstep()));
                }
                if (message.superstep != this.getSuperstep() - 1L) {
                    throw new IllegalStateException("compute: Impossible to not get a messsage from the previous superstep, current superstep = " + this.getSuperstep());
                }
                if (message.sourceVertexId == ((LongWritable)vertex.getId()).get() - 1L || ((LongWritable)vertex.getId()).get() == 0L) continue;
                throw new IllegalStateException("compute: Impossible that this message didn't come from the previous vertex and came from " + message.sourceVertexId);
            }
            int vertexValue = ((IntWritable)vertex.getValue()).get();
            vertex.setValue((Writable)new IntWritable(vertexValue + (int)msgValue));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("compute: vertex " + vertex.getId() + " has value " + vertex.getValue() + " on superstep " + this.getSuperstep()));
            }
            for (Edge edge : vertex.getEdges()) {
                FloatWritable newEdgeValue = new FloatWritable(((FloatWritable)edge.getValue()).get() + (float)vertexValue);
                Edge newEdge = EdgeFactory.create((WritableComparable)edge.getTargetVertexId(), (Writable)newEdgeValue);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("compute: vertex " + vertex.getId() + " sending edgeValue " + edge.getValue() + " vertexValue " + vertexValue + " total " + newEdgeValue + " to vertex " + edge.getTargetVertexId() + " on superstep " + this.getSuperstep()));
                }
                vertex.addEdge(newEdge);
                this.sendMessage(edge.getTargetVertexId(), new VerifiableMessage(this.getSuperstep(), ((LongWritable)vertex.getId()).get(), newEdgeValue.get()));
            }
        }

        static {
            SUPERSTEPS = 6;
            LOG = Logger.getLogger(VerifyMessageComputation.class);
        }

        public static class VerifyMessageVertexWorkerContext
        extends WorkerContext {
            public void preApplication() throws InstantiationException, IllegalAccessException {
                SUPERSTEPS = this.getContext().getConfiguration().getInt(VerifyMessageComputation.SUPERSTEP_COUNT, SUPERSTEPS);
            }

            public void postApplication() {
                LongWritable sumAggregatorValue = (LongWritable)this.getAggregatedValue(LongSumAggregator.class.getName());
                FINAL_SUM = sumAggregatorValue.get();
            }

            public void preSuperstep() {
            }

            public void postSuperstep() {
            }
        }
    }

    public static class VerifiableMessage
    implements Writable {
        private long superstep;
        private long sourceVertexId;
        private float value;

        public VerifiableMessage() {
        }

        public VerifiableMessage(long superstep, long sourceVertexId, float value) {
            this.superstep = superstep;
            this.sourceVertexId = sourceVertexId;
            this.value = value;
        }

        public void readFields(DataInput input) throws IOException {
            this.superstep = input.readLong();
            this.sourceVertexId = input.readLong();
            this.value = input.readFloat();
        }

        public void write(DataOutput output) throws IOException {
            output.writeLong(this.superstep);
            output.writeLong(this.sourceVertexId);
            output.writeFloat(this.value);
        }

        public String toString() {
            return "(superstep=" + this.superstep + ",sourceVertexId=" + this.sourceVertexId + ",value=" + this.value + ")";
        }
    }
}

