/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.worker.DefaultWorkerContext;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.LongWritable;

public class TestComputationStateComputation
extends BasicComputation<LongWritable, DoubleWritable, FloatWritable, DoubleWritable> {
    public static final int NUM_COMPUTE_THREADS = 10;
    public static final int NUM_VERTICES = 100;
    public static final int NUM_PARTITIONS = 25;
    private long counter;

    public void compute(Vertex<LongWritable, DoubleWritable, FloatWritable> vertex, Iterable<DoubleWritable> messages) throws IOException {
        ++this.counter;
        if (this.getSuperstep() > 5L) {
            vertex.voteToHalt();
        }
    }

    public void preSuperstep() {
        this.counter = ((TestComputationStateWorkerContext)this.getWorkerContext()).superstepCounter;
    }

    public void postSuperstep() {
        ((TestComputationStateWorkerContext)this.getWorkerContext()).totalCounter.addAndGet(this.counter);
    }

    private static void assertEquals(long expected, long actual) {
        if (expected != actual) {
            throw new RuntimeException("expected: " + expected + ", actual: " + actual);
        }
    }

    public static class TestComputationStateWorkerContext
    extends DefaultWorkerContext {
        private long superstepCounter;
        private AtomicLong totalCounter;

        public void preSuperstep() {
            this.superstepCounter = this.getSuperstep();
            this.totalCounter = new AtomicLong(0L);
        }

        public void postSuperstep() {
            TestComputationStateComputation.assertEquals(this.totalCounter.get(), 25L * this.superstepCounter + this.getTotalNumVertices());
        }
    }
}

