/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.giraph.examples.SimpleSuperstepComputation;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.job.GiraphJob;
import org.apache.giraph.worker.WorkerContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class SimpleVertexWithWorkerContext
implements Tool {
    public static final String OUTPUTDIR = "svwwc.outputdir";
    private static final int TESTLENGTH = 30;
    private Configuration conf;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public int run(String[] args) throws Exception {
        if (args.length != 2) {
            throw new IllegalArgumentException("run: Must have 2 arguments <output path> <# of workers>");
        }
        GiraphJob job = new GiraphJob(this.getConf(), this.getClass().getName());
        job.getConfiguration().setComputationClass(SimpleComputation.class);
        job.getConfiguration().setVertexInputFormatClass(SimpleSuperstepComputation.SimpleSuperstepVertexInputFormat.class);
        job.getConfiguration().setWorkerContextClass(EmitterWorkerContext.class);
        job.getConfiguration().set(OUTPUTDIR, args[0]);
        job.getConfiguration().setWorkerConfiguration(Integer.parseInt(args[1]), Integer.parseInt(args[1]), 100.0f);
        if (job.run(true)) {
            return 0;
        }
        return -1;
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Tool)new SimpleVertexWithWorkerContext(), (String[])args));
    }

    public static class EmitterWorkerContext
    extends WorkerContext {
        private static final String FILENAME = "emitter_";
        private DataOutputStream out;

        public void preApplication() {
            Mapper.Context context = this.getContext();
            try {
                FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
                String p = context.getConfiguration().get(SimpleVertexWithWorkerContext.OUTPUTDIR);
                if (p == null) {
                    throw new IllegalArgumentException("svwwc.outputdir undefined!");
                }
                Path path = new Path(p);
                if (!fs.exists(path)) {
                    throw new IllegalArgumentException(path + " doesn't exist");
                }
                Path outF = new Path(path, FILENAME + context.getTaskAttemptID());
                if (fs.exists(outF)) {
                    throw new IllegalArgumentException(outF + " aready exists");
                }
                this.out = fs.create(outF);
            }
            catch (IOException e) {
                throw new RuntimeException("can't initialize WorkerContext", e);
            }
        }

        public void postApplication() {
            if (this.out != null) {
                try {
                    this.out.flush();
                    this.out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("can't finalize WorkerContext", e);
                }
                this.out = null;
            }
        }

        public void preSuperstep() {
        }

        public void postSuperstep() {
        }

        public void emit(String s) {
            try {
                this.out.writeUTF(s);
            }
            catch (IOException e) {
                throw new RuntimeException("can't emit", e);
            }
        }
    }

    public static class SimpleComputation
    extends BasicComputation<LongWritable, IntWritable, FloatWritable, DoubleWritable> {
        public void compute(Vertex<LongWritable, IntWritable, FloatWritable> vertex, Iterable<DoubleWritable> messages) throws IOException {
            long superstep = this.getSuperstep();
            if (superstep < 30L) {
                EmitterWorkerContext emitter = (EmitterWorkerContext)this.getWorkerContext();
                emitter.emit("vertexId=" + vertex.getId() + " superstep=" + superstep + "\n");
            } else {
                vertex.voteToHalt();
            }
        }
    }
}

