/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.utils.ArrayListWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;

public class SimpleTriangleClosingComputation
extends BasicComputation<IntWritable, IntArrayListWritable, NullWritable, IntWritable> {
    private Map<IntWritable, Integer> closeMap = Maps.newHashMap();

    public void compute(Vertex<IntWritable, IntArrayListWritable, NullWritable> vertex, Iterable<IntWritable> messages) throws IOException {
        if (this.getSuperstep() == 0L) {
            for (Edge edge : vertex.getEdges()) {
                this.sendMessageToAllEdges(vertex, (Writable)edge.getTargetVertexId());
            }
        } else {
            Pair pair;
            for (IntWritable message : messages) {
                int current = this.closeMap.get(message) == null ? 0 : this.closeMap.get(message) + 1;
                this.closeMap.put(message, current);
            }
            TreeSet sortedResults = Sets.newTreeSet();
            for (Map.Entry<IntWritable, Integer> entry : this.closeMap.entrySet()) {
                sortedResults.add(new Pair(entry.getKey(), entry.getValue()));
            }
            IntArrayListWritable outputList = new IntArrayListWritable();
            Iterator i$ = sortedResults.iterator();
            while (i$.hasNext() && (pair = (Pair)i$.next()).value > 0) {
                outputList.add(pair.key);
            }
            vertex.setValue((Writable)outputList);
        }
        vertex.voteToHalt();
    }

    public static class IntArrayListWritable
    extends ArrayListWritable<IntWritable> {
        public void setClass() {
            this.setClass(IntWritable.class);
        }
    }

    public static class Pair
    implements Comparable<Pair> {
        private final IntWritable key;
        private final Integer value;

        public Pair(IntWritable k, Integer v) {
            this.key = k;
            this.value = v;
        }

        public IntWritable getKey() {
            return this.key;
        }

        public Integer getValue() {
            return this.value;
        }

        @Override
        public int compareTo(Pair other) {
            return other.value - this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Pair) {
                Pair other = (Pair)obj;
                return Objects.equal((Object)this.value, (Object)other.value);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.value});
        }
    }
}

