/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.examples.GeneratedVertexReader;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.VertexReader;
import org.apache.giraph.io.formats.GeneratedVertexInputFormat;
import org.apache.giraph.io.formats.TextVertexOutputFormat;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;

public class SimpleSuperstepComputation
extends BasicComputation<LongWritable, IntWritable, FloatWritable, IntWritable> {
    public void compute(Vertex<LongWritable, IntWritable, FloatWritable> vertex, Iterable<IntWritable> messages) throws IOException {
        if (this.getTotalNumVertices() < 1L) {
            throw new IllegalStateException("compute: Illegal total vertices " + this.getTotalNumVertices());
        }
        if (this.getTotalNumEdges() < 0L) {
            throw new IllegalStateException("compute: Illegal total edges " + this.getTotalNumEdges());
        }
        if (vertex.isHalted()) {
            throw new IllegalStateException("compute: Impossible to be halted - " + vertex.isHalted());
        }
        if (this.getSuperstep() > 3L) {
            vertex.voteToHalt();
        }
    }

    public static class SimpleSuperstepVertexOutputFormat
    extends TextVertexOutputFormat<LongWritable, IntWritable, FloatWritable> {
        public TextVertexOutputFormat.TextVertexWriter createVertexWriter(TaskAttemptContext context) throws IOException, InterruptedException {
            return new SimpleSuperstepVertexWriter();
        }

        public class SimpleSuperstepVertexWriter
        extends TextVertexOutputFormat.TextVertexWriter {
            public SimpleSuperstepVertexWriter() {
                super((TextVertexOutputFormat)SimpleSuperstepVertexOutputFormat.this);
            }

            public void writeVertex(Vertex<LongWritable, IntWritable, FloatWritable> vertex) throws IOException, InterruptedException {
                this.getRecordWriter().write((Object)new Text(((LongWritable)vertex.getId()).toString()), (Object)new Text(((IntWritable)vertex.getValue()).toString()));
            }
        }
    }

    public static class SimpleSuperstepVertexInputFormat
    extends GeneratedVertexInputFormat<LongWritable, IntWritable, FloatWritable> {
        public VertexReader<LongWritable, IntWritable, FloatWritable> createVertexReader(InputSplit split, TaskAttemptContext context) throws IOException {
            return new SimpleSuperstepVertexReader();
        }
    }

    public static class SimpleSuperstepVertexReader
    extends GeneratedVertexReader<LongWritable, IntWritable, FloatWritable> {
        private static final Logger LOG = Logger.getLogger(SimpleSuperstepVertexReader.class);

        public boolean nextVertex() throws IOException, InterruptedException {
            return this.totalRecords > this.recordsRead;
        }

        public Vertex<LongWritable, IntWritable, FloatWritable> getCurrentVertex() throws IOException, InterruptedException {
            Vertex vertex = this.getConf().createVertex();
            long tmpId = this.reverseIdOrder ? (long)(this.inputSplit.getSplitIndex() + 1) * this.totalRecords - this.recordsRead - 1L : (long)this.inputSplit.getSplitIndex() * this.totalRecords + this.recordsRead;
            LongWritable vertexId = new LongWritable(tmpId);
            IntWritable vertexValue = new IntWritable((int)(vertexId.get() * 10L));
            LinkedList edges = Lists.newLinkedList();
            long targetVertexId = (vertexId.get() + 1L) % ((long)this.inputSplit.getNumSplits() * this.totalRecords);
            float edgeValue = (float)vertexId.get() * 100.0f;
            edges.add(EdgeFactory.create((WritableComparable)new LongWritable(targetVertexId), (Writable)new FloatWritable(edgeValue)));
            vertex.initialize((WritableComparable)vertexId, (Writable)vertexValue, (Iterable)edges);
            ++this.recordsRead;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("next: Return vertexId=" + ((LongWritable)vertex.getId()).get() + ", vertexValue=" + vertex.getValue() + ", targetVertexId=" + targetVertexId + ", edgeValue=" + edgeValue));
            }
            return vertex;
        }
    }
}

