/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import java.io.IOException;
import org.apache.giraph.conf.LongConfOption;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.examples.Algorithm;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;

@Algorithm(name="Shortest paths", description="Finds all shortest paths from a selected vertex")
public class SimpleShortestPathsComputation
extends BasicComputation<LongWritable, DoubleWritable, FloatWritable, DoubleWritable> {
    public static final LongConfOption SOURCE_ID = new LongConfOption("SimpleShortestPathsVertex.sourceId", 1L, "The shortest paths id");
    private static final Logger LOG = Logger.getLogger(SimpleShortestPathsComputation.class);

    private boolean isSource(Vertex<LongWritable, ?, ?> vertex) {
        return ((LongWritable)vertex.getId()).get() == SOURCE_ID.get((Configuration)this.getConf());
    }

    public void compute(Vertex<LongWritable, DoubleWritable, FloatWritable> vertex, Iterable<DoubleWritable> messages) throws IOException {
        if (this.getSuperstep() == 0L) {
            vertex.setValue((Writable)new DoubleWritable(Double.MAX_VALUE));
        }
        double minDist = this.isSource(vertex) ? 0.0 : Double.MAX_VALUE;
        for (DoubleWritable message : messages) {
            minDist = Math.min(minDist, message.get());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Vertex " + vertex.getId() + " got minDist = " + minDist + " vertex value = " + vertex.getValue()));
        }
        if (minDist < ((DoubleWritable)vertex.getValue()).get()) {
            vertex.setValue((Writable)new DoubleWritable(minDist));
            for (Edge edge : vertex.getEdges()) {
                double distance = minDist + (double)((FloatWritable)edge.getValue()).get();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Vertex " + vertex.getId() + " sent to " + edge.getTargetVertexId() + " = " + distance));
                }
                this.sendMessage(edge.getTargetVertexId(), (Writable)new DoubleWritable(distance));
            }
        }
        vertex.voteToHalt();
    }
}

