/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.giraph.aggregators.DoubleMaxAggregator;
import org.apache.giraph.aggregators.DoubleMinAggregator;
import org.apache.giraph.aggregators.LongSumAggregator;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.examples.Algorithm;
import org.apache.giraph.examples.GeneratedVertexReader;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.VertexReader;
import org.apache.giraph.io.formats.GeneratedVertexInputFormat;
import org.apache.giraph.io.formats.TextVertexOutputFormat;
import org.apache.giraph.master.DefaultMasterCompute;
import org.apache.giraph.worker.WorkerContext;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;

@Algorithm(name="Page rank")
public class SimplePageRankComputation
extends BasicComputation<LongWritable, DoubleWritable, FloatWritable, DoubleWritable> {
    public static final int MAX_SUPERSTEPS = 30;
    private static final Logger LOG = Logger.getLogger(SimplePageRankComputation.class);
    private static String SUM_AGG = "sum";
    private static String MIN_AGG = "min";
    private static String MAX_AGG = "max";

    public void compute(Vertex<LongWritable, DoubleWritable, FloatWritable> vertex, Iterable<DoubleWritable> messages) throws IOException {
        if (this.getSuperstep() >= 1L) {
            double sum = 0.0;
            for (DoubleWritable message : messages) {
                sum += message.get();
            }
            DoubleWritable vertexValue = new DoubleWritable((double)(0.15f / (float)this.getTotalNumVertices()) + (double)0.85f * sum);
            vertex.setValue((Writable)vertexValue);
            this.aggregate(MAX_AGG, (Writable)vertexValue);
            this.aggregate(MIN_AGG, (Writable)vertexValue);
            this.aggregate(SUM_AGG, (Writable)new LongWritable(1L));
            LOG.info((Object)(vertex.getId() + ": PageRank=" + vertexValue + " max=" + this.getAggregatedValue(MAX_AGG) + " min=" + this.getAggregatedValue(MIN_AGG)));
        }
        if (this.getSuperstep() < 30L) {
            long edges = vertex.getNumEdges();
            this.sendMessageToAllEdges(vertex, (Writable)new DoubleWritable(((DoubleWritable)vertex.getValue()).get() / (double)edges));
        } else {
            vertex.voteToHalt();
        }
    }

    public static class SimplePageRankVertexOutputFormat
    extends TextVertexOutputFormat<LongWritable, DoubleWritable, FloatWritable> {
        public TextVertexOutputFormat.TextVertexWriter createVertexWriter(TaskAttemptContext context) throws IOException, InterruptedException {
            return new SimplePageRankVertexWriter();
        }

        public class SimplePageRankVertexWriter
        extends TextVertexOutputFormat.TextVertexWriter {
            public SimplePageRankVertexWriter() {
                super((TextVertexOutputFormat)SimplePageRankVertexOutputFormat.this);
            }

            public void writeVertex(Vertex<LongWritable, DoubleWritable, FloatWritable> vertex) throws IOException, InterruptedException {
                this.getRecordWriter().write((Object)new Text(((LongWritable)vertex.getId()).toString()), (Object)new Text(((DoubleWritable)vertex.getValue()).toString()));
            }
        }
    }

    public static class SimplePageRankVertexInputFormat
    extends GeneratedVertexInputFormat<LongWritable, DoubleWritable, FloatWritable> {
        public VertexReader<LongWritable, DoubleWritable, FloatWritable> createVertexReader(InputSplit split, TaskAttemptContext context) throws IOException {
            return new SimplePageRankVertexReader();
        }
    }

    public static class SimplePageRankVertexReader
    extends GeneratedVertexReader<LongWritable, DoubleWritable, FloatWritable> {
        private static final Logger LOG = Logger.getLogger(SimplePageRankVertexReader.class);

        public boolean nextVertex() {
            return this.totalRecords > this.recordsRead;
        }

        public Vertex<LongWritable, DoubleWritable, FloatWritable> getCurrentVertex() throws IOException {
            Vertex vertex = this.getConf().createVertex();
            LongWritable vertexId = new LongWritable((long)this.inputSplit.getSplitIndex() * this.totalRecords + this.recordsRead);
            DoubleWritable vertexValue = new DoubleWritable((double)vertexId.get() * 10.0);
            long targetVertexId = (vertexId.get() + 1L) % ((long)this.inputSplit.getNumSplits() * this.totalRecords);
            float edgeValue = (float)vertexId.get() * 100.0f;
            LinkedList edges = Lists.newLinkedList();
            edges.add(EdgeFactory.create((WritableComparable)new LongWritable(targetVertexId), (Writable)new FloatWritable(edgeValue)));
            vertex.initialize((WritableComparable)vertexId, (Writable)vertexValue, (Iterable)edges);
            ++this.recordsRead;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("next: Return vertexId=" + ((LongWritable)vertex.getId()).get() + ", vertexValue=" + vertex.getValue() + ", targetVertexId=" + targetVertexId + ", edgeValue=" + edgeValue));
            }
            return vertex;
        }
    }

    public static class SimplePageRankMasterCompute
    extends DefaultMasterCompute {
        public void initialize() throws InstantiationException, IllegalAccessException {
            this.registerAggregator(SUM_AGG, LongSumAggregator.class);
            this.registerPersistentAggregator(MIN_AGG, DoubleMinAggregator.class);
            this.registerPersistentAggregator(MAX_AGG, DoubleMaxAggregator.class);
        }
    }

    public static class SimplePageRankWorkerContext
    extends WorkerContext {
        private static double FINAL_MAX;
        private static double FINAL_MIN;
        private static long FINAL_SUM;

        public static double getFinalMax() {
            return FINAL_MAX;
        }

        public static double getFinalMin() {
            return FINAL_MIN;
        }

        public static long getFinalSum() {
            return FINAL_SUM;
        }

        public void preApplication() throws InstantiationException, IllegalAccessException {
        }

        public void postApplication() {
            FINAL_SUM = ((LongWritable)this.getAggregatedValue(SUM_AGG)).get();
            FINAL_MAX = ((DoubleWritable)this.getAggregatedValue(MAX_AGG)).get();
            FINAL_MIN = ((DoubleWritable)this.getAggregatedValue(MIN_AGG)).get();
            LOG.info((Object)("aggregatedNumVertices=" + FINAL_SUM));
            LOG.info((Object)("aggregatedMaxPageRank=" + FINAL_MAX));
            LOG.info((Object)("aggregatedMinPageRank=" + FINAL_MIN));
        }

        public void preSuperstep() {
            if (this.getSuperstep() >= 3L) {
                LOG.info((Object)("aggregatedNumVertices=" + this.getAggregatedValue(SUM_AGG) + " NumVertices=" + this.getTotalNumVertices()));
                if (((LongWritable)this.getAggregatedValue(SUM_AGG)).get() != this.getTotalNumVertices()) {
                    throw new RuntimeException("wrong value of SumAggreg: " + this.getAggregatedValue(SUM_AGG) + ", should be: " + this.getTotalNumVertices());
                }
                DoubleWritable maxPagerank = (DoubleWritable)this.getAggregatedValue(MAX_AGG);
                LOG.info((Object)("aggregatedMaxPageRank=" + maxPagerank.get()));
                DoubleWritable minPagerank = (DoubleWritable)this.getAggregatedValue(MIN_AGG);
                LOG.info((Object)("aggregatedMinPageRank=" + minPagerank.get()));
            }
        }

        public void postSuperstep() {
        }
    }
}

