/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import java.io.IOException;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.worker.WorkerContext;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

public class SimpleMutateGraphComputation
extends BasicComputation<LongWritable, DoubleWritable, FloatWritable, DoubleWritable> {
    private static Logger LOG = Logger.getLogger(SimpleMutateGraphComputation.class);
    private long maxRanges = 100L;

    private long rangeVertexIdStart(int range) {
        return Long.MAX_VALUE / this.maxRanges * (long)range;
    }

    public void compute(Vertex<LongWritable, DoubleWritable, FloatWritable> vertex, Iterable<DoubleWritable> messages) throws IOException {
        SimpleMutateGraphVertexWorkerContext workerContext = (SimpleMutateGraphVertexWorkerContext)this.getWorkerContext();
        if (this.getSuperstep() == 0L) {
            LOG.debug((Object)("Reached superstep " + this.getSuperstep()));
        } else if (this.getSuperstep() == 1L) {
            LongWritable destVertexId = new LongWritable(this.rangeVertexIdStart(1) + ((LongWritable)vertex.getId()).get());
            this.sendMessage((WritableComparable)destVertexId, (Writable)new DoubleWritable(0.0));
        } else if (this.getSuperstep() == 2L) {
            LOG.debug((Object)("Reached superstep " + this.getSuperstep()));
        } else if (this.getSuperstep() == 3L) {
            long vertexCount = workerContext.getVertexCount();
            if (vertexCount * 2L != this.getTotalNumVertices()) {
                throw new IllegalStateException("Impossible to have " + this.getTotalNumVertices() + " vertices when should have " + vertexCount * 2L + " on superstep " + this.getSuperstep());
            }
            long edgeCount = workerContext.getEdgeCount();
            if (edgeCount != this.getTotalNumEdges()) {
                throw new IllegalStateException("Impossible to have " + this.getTotalNumEdges() + " edges when should have " + edgeCount + " on superstep " + this.getSuperstep());
            }
            LongWritable vertexIndex = new LongWritable(this.rangeVertexIdStart(3) + ((LongWritable)vertex.getId()).get());
            this.addVertexRequest((WritableComparable)vertexIndex, (Writable)new DoubleWritable(0.0));
            this.addEdgeRequest((WritableComparable)vertexIndex, EdgeFactory.create((WritableComparable)vertex.getId(), (Writable)new FloatWritable(0.0f)));
        } else if (this.getSuperstep() == 4L) {
            LOG.debug((Object)("Reached superstep " + this.getSuperstep()));
        } else if (this.getSuperstep() == 5L) {
            long vertexCount = workerContext.getVertexCount();
            if (vertexCount * 2L != this.getTotalNumVertices()) {
                throw new IllegalStateException("Impossible to have " + this.getTotalNumVertices() + " when should have " + vertexCount * 2L + " on superstep " + this.getSuperstep());
            }
            long edgeCount = workerContext.getEdgeCount();
            if (edgeCount + vertexCount != this.getTotalNumEdges()) {
                throw new IllegalStateException("Impossible to have " + this.getTotalNumEdges() + " edges when should have " + edgeCount + vertexCount + " on superstep " + this.getSuperstep());
            }
            LongWritable vertexIndex = new LongWritable(this.rangeVertexIdStart(3) + ((LongWritable)vertex.getId()).get());
            workerContext.increaseEdgesRemoved();
            this.removeEdgesRequest((WritableComparable)vertexIndex, vertex.getId());
        } else if (this.getSuperstep() == 6L) {
            if (((LongWritable)vertex.getId()).compareTo(new LongWritable(this.rangeVertexIdStart(3))) >= 0) {
                this.removeVertexRequest(vertex.getId());
            }
        } else if (this.getSuperstep() == 7L) {
            long origEdgeCount = workerContext.getOrigEdgeCount();
            if (origEdgeCount != this.getTotalNumEdges()) {
                throw new IllegalStateException("Impossible to have " + this.getTotalNumEdges() + " edges when should have " + origEdgeCount + " on superstep " + this.getSuperstep());
            }
        } else if (this.getSuperstep() == 8L) {
            long vertexCount = workerContext.getVertexCount();
            if (vertexCount / 2L != this.getTotalNumVertices()) {
                throw new IllegalStateException("Impossible to have " + this.getTotalNumVertices() + " vertices when should have " + vertexCount / 2L + " on superstep " + this.getSuperstep());
            }
        } else {
            vertex.voteToHalt();
        }
    }

    public static class SimpleMutateGraphVertexWorkerContext
    extends WorkerContext {
        private long vertexCount;
        private long edgeCount;
        private long origEdgeCount;
        private int edgesRemoved = 0;

        public void preApplication() throws InstantiationException, IllegalAccessException {
        }

        public void postApplication() {
        }

        public void preSuperstep() {
        }

        public void postSuperstep() {
            this.vertexCount = this.getTotalNumVertices();
            this.edgeCount = this.getTotalNumEdges();
            if (this.getSuperstep() == 1L) {
                this.origEdgeCount = this.edgeCount;
            }
            LOG.info((Object)("Got " + this.vertexCount + " vertices, " + this.edgeCount + " edges on superstep " + this.getSuperstep()));
            LOG.info((Object)("Removed " + this.edgesRemoved));
            this.edgesRemoved = 0;
        }

        public long getVertexCount() {
            return this.vertexCount;
        }

        public long getEdgeCount() {
            return this.edgeCount;
        }

        public long getOrigEdgeCount() {
            return this.origEdgeCount;
        }

        public void increaseEdgesRemoved() {
            ++this.edgesRemoved;
        }
    }
}

