/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import java.io.IOException;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

public class SimpleMsgComputation
extends BasicComputation<LongWritable, IntWritable, FloatWritable, IntWritable> {
    private static Logger LOG = Logger.getLogger(SimpleMsgComputation.class);

    public void compute(Vertex<LongWritable, IntWritable, FloatWritable> vertex, Iterable<IntWritable> messages) throws IOException {
        if (((LongWritable)vertex.getId()).equals((Object)new LongWritable(2L))) {
            this.sendMessage((WritableComparable)new LongWritable(1L), (Writable)new IntWritable(101));
            this.sendMessage((WritableComparable)new LongWritable(1L), (Writable)new IntWritable(102));
            this.sendMessage((WritableComparable)new LongWritable(1L), (Writable)new IntWritable(103));
        }
        if (!((LongWritable)vertex.getId()).equals((Object)new LongWritable(1L))) {
            vertex.voteToHalt();
        } else {
            int sum = 0;
            for (IntWritable message : messages) {
                sum += message.get();
            }
            LOG.info((Object)("compute: Received a sum of " + sum + " (will stop on 306)"));
            if (sum == 306) {
                vertex.voteToHalt();
            }
        }
        if (this.getSuperstep() > 3L) {
            System.err.println("compute: Vertex 1 failed to receive messages in time");
            vertex.voteToHalt();
        }
    }
}

