/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import java.io.IOException;
import org.apache.giraph.aggregators.DoubleOverwriteAggregator;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.master.DefaultMasterCompute;
import org.apache.giraph.worker.WorkerContext;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;

public class SimpleMasterComputeComputation
extends BasicComputation<LongWritable, DoubleWritable, FloatWritable, DoubleWritable> {
    public static final String SMC_AGG = "simplemastercompute.aggregator";
    private static final Logger LOG = Logger.getLogger(SimpleMasterComputeComputation.class);

    public void compute(Vertex<LongWritable, DoubleWritable, FloatWritable> vertex, Iterable<DoubleWritable> messages) throws IOException {
        double oldSum = this.getSuperstep() == 0L ? 0.0 : ((DoubleWritable)vertex.getValue()).get();
        double newValue = ((DoubleWritable)this.getAggregatedValue(SMC_AGG)).get();
        double newSum = oldSum + newValue;
        vertex.setValue((Writable)new DoubleWritable(newSum));
        SimpleMasterComputeWorkerContext workerContext = (SimpleMasterComputeWorkerContext)this.getWorkerContext();
        SimpleMasterComputeWorkerContext.setFinalSum(newSum);
        LOG.info((Object)("Current sum: " + newSum));
    }

    public static class SimpleMasterCompute
    extends DefaultMasterCompute {
        public void compute() {
            this.setAggregatedValue(SimpleMasterComputeComputation.SMC_AGG, (Writable)new DoubleWritable((double)this.getSuperstep() / 2.0 + 1.0));
            if (this.getSuperstep() == 10L) {
                this.haltComputation();
            }
        }

        public void initialize() throws InstantiationException, IllegalAccessException {
            this.registerAggregator(SimpleMasterComputeComputation.SMC_AGG, DoubleOverwriteAggregator.class);
        }
    }

    public static class SimpleMasterComputeWorkerContext
    extends WorkerContext {
        private static double FINAL_SUM;

        public void preApplication() throws InstantiationException, IllegalAccessException {
        }

        public void preSuperstep() {
        }

        public void postSuperstep() {
        }

        public void postApplication() {
        }

        public static void setFinalSum(double sum) {
            FINAL_SUM = sum;
        }

        public static double getFinalSum() {
            return FINAL_SUM;
        }
    }
}

