/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import java.io.IOException;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.examples.Algorithm;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;

@Algorithm(name="Indegree Count")
public class SimpleInDegreeCountComputation
extends BasicComputation<LongWritable, LongWritable, DoubleWritable, DoubleWritable> {
    public void compute(Vertex<LongWritable, LongWritable, DoubleWritable> vertex, Iterable<DoubleWritable> messages) throws IOException {
        if (this.getSuperstep() == 0L) {
            Iterable edges = vertex.getEdges();
            for (Edge edge : edges) {
                this.sendMessage(edge.getTargetVertexId(), (Writable)new DoubleWritable(1.0));
            }
        } else {
            long sum = 0L;
            for (DoubleWritable message : messages) {
                ++sum;
            }
            LongWritable vertexValue = (LongWritable)vertex.getValue();
            vertexValue.set(sum);
            vertex.setValue((Writable)vertexValue);
            vertex.voteToHalt();
        }
    }
}

