/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import java.io.IOException;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;

public class SimpleFailComputation
extends BasicComputation<LongWritable, DoubleWritable, FloatWritable, DoubleWritable> {
    private static Logger LOG = Logger.getLogger(SimpleFailComputation.class);
    private static long SUPERSTEP = 0L;

    public void compute(Vertex<LongWritable, DoubleWritable, FloatWritable> vertex, Iterable<DoubleWritable> messages) throws IOException {
        if (this.getSuperstep() >= 1L) {
            double sum = 0.0;
            for (DoubleWritable message : messages) {
                sum += message.get();
            }
            DoubleWritable vertexValue = new DoubleWritable((double)(0.15f / (float)this.getTotalNumVertices()) + (double)0.85f * sum);
            vertex.setValue((Writable)vertexValue);
            if (this.getSuperstep() < 30L) {
                if (this.getSuperstep() == 20L) {
                    if (((LongWritable)vertex.getId()).get() == 10L) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            LOG.info((Object)"Sleep interrupted ", (Throwable)e);
                        }
                        System.exit(1);
                    } else if (this.getSuperstep() - SUPERSTEP > 10L) {
                        return;
                    }
                }
                long edges = vertex.getNumEdges();
                this.sendMessageToAllEdges(vertex, (Writable)new DoubleWritable(((DoubleWritable)vertex.getValue()).get() / (double)edges));
            } else {
                vertex.voteToHalt();
            }
            SimpleFailComputation.setSuperstep(this.getSuperstep());
        }
    }

    private static void setSuperstep(long superstep) {
        SUPERSTEP = superstep;
    }
}

