/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import java.io.IOException;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

public class SimpleCombinerComputation
extends BasicComputation<LongWritable, IntWritable, FloatWritable, IntWritable> {
    private static Logger LOG = Logger.getLogger(SimpleCombinerComputation.class);

    public void compute(Vertex<LongWritable, IntWritable, FloatWritable> vertex, Iterable<IntWritable> messages) throws IOException {
        if (((LongWritable)vertex.getId()).equals((Object)new LongWritable(2L))) {
            this.sendMessage((WritableComparable)new LongWritable(1L), (Writable)new IntWritable(101));
            this.sendMessage((WritableComparable)new LongWritable(1L), (Writable)new IntWritable(102));
            this.sendMessage((WritableComparable)new LongWritable(1L), (Writable)new IntWritable(103));
        }
        if (!((LongWritable)vertex.getId()).equals((Object)new LongWritable(1L))) {
            vertex.voteToHalt();
        } else {
            int sum = 0;
            int num = 0;
            for (IntWritable message : messages) {
                sum += message.get();
                ++num;
            }
            LOG.info((Object)("TestCombinerVertex: Received a sum of " + sum + " (should have 306 with a single message value)"));
            if (num == 1 && sum == 306) {
                vertex.voteToHalt();
            }
        }
        if (this.getSuperstep() > 3L) {
            throw new IllegalStateException("TestCombinerVertex: Vertex 1 failed to receive messages in time");
        }
    }
}

