/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.giraph.aggregators.LongSumAggregator;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.formats.GeneratedVertexInputFormat;
import org.apache.giraph.io.formats.IdWithValueTextOutputFormat;
import org.apache.giraph.job.GiraphJob;
import org.apache.giraph.master.DefaultMasterCompute;
import org.apache.giraph.worker.WorkerContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class SimpleCheckpoint
implements Tool {
    public static final int FAULTING_SUPERSTEP = 4;
    public static final long FAULTING_VERTEX_ID = 1L;
    public static final String SUPERSTEP_COUNT = "simpleCheckpointVertex.superstepCount";
    public static final String ENABLE_FAULT = "simpleCheckpointVertex.enableFault";
    private static final Logger LOG = Logger.getLogger(SimpleCheckpoint.class);
    private Configuration conf;

    public int run(String[] args) throws Exception {
        Options options = new Options();
        options.addOption("h", "help", false, "Help");
        options.addOption("v", "verbose", false, "Verbose");
        options.addOption("w", "workers", true, "Number of workers");
        options.addOption("s", "supersteps", true, "Supersteps to execute before finishing");
        options.addOption("w", "workers", true, "Minimum number of workers");
        options.addOption("o", "outputDirectory", true, "Output directory");
        HelpFormatter formatter = new HelpFormatter();
        if (args.length == 0) {
            formatter.printHelp(this.getClass().getName(), options, true);
            return 0;
        }
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption('h')) {
            formatter.printHelp(this.getClass().getName(), options, true);
            return 0;
        }
        if (!cmd.hasOption('w')) {
            LOG.info((Object)"Need to choose the number of workers (-w)");
            return -1;
        }
        if (!cmd.hasOption('o')) {
            LOG.info((Object)"Need to set the output directory (-o)");
            return -1;
        }
        GiraphJob bspJob = new GiraphJob(this.getConf(), this.getClass().getName());
        bspJob.getConfiguration().setComputationClass(SimpleCheckpointComputation.class);
        bspJob.getConfiguration().setVertexInputFormatClass(GeneratedVertexInputFormat.class);
        bspJob.getConfiguration().setVertexOutputFormatClass(IdWithValueTextOutputFormat.class);
        bspJob.getConfiguration().setWorkerContextClass(SimpleCheckpointVertexWorkerContext.class);
        bspJob.getConfiguration().setMasterComputeClass(SimpleCheckpointVertexMasterCompute.class);
        int minWorkers = Integer.parseInt(cmd.getOptionValue('w'));
        int maxWorkers = Integer.parseInt(cmd.getOptionValue('w'));
        bspJob.getConfiguration().setWorkerConfiguration(minWorkers, maxWorkers, 100.0f);
        FileOutputFormat.setOutputPath((Job)bspJob.getInternalJob(), (Path)new Path(cmd.getOptionValue('o')));
        boolean verbose = false;
        if (cmd.hasOption('v')) {
            verbose = true;
        }
        if (cmd.hasOption('s')) {
            this.getConf().setInt(SUPERSTEP_COUNT, Integer.parseInt(cmd.getOptionValue('s')));
        }
        if (bspJob.run(verbose)) {
            return 0;
        }
        return -1;
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Tool)new SimpleCheckpoint(), (String[])args));
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public static class SimpleCheckpointVertexMasterCompute
    extends DefaultMasterCompute {
        public void initialize() throws InstantiationException, IllegalAccessException {
            this.registerAggregator(LongSumAggregator.class.getName(), LongSumAggregator.class);
        }
    }

    public static class SimpleCheckpointVertexWorkerContext
    extends WorkerContext {
        public static final String FAULT_FILE = "/tmp/faultFile";
        private static long FINAL_SUM;
        private int supersteps = 6;
        private boolean enableFault = false;

        public static long getFinalSum() {
            return FINAL_SUM;
        }

        public void preApplication() throws InstantiationException, IllegalAccessException {
            this.supersteps = this.getContext().getConfiguration().getInt(SimpleCheckpoint.SUPERSTEP_COUNT, this.supersteps);
            this.enableFault = this.getContext().getConfiguration().getBoolean(SimpleCheckpoint.ENABLE_FAULT, false);
        }

        public void postApplication() {
            SimpleCheckpointVertexWorkerContext.setFinalSum(((LongWritable)this.getAggregatedValue(LongSumAggregator.class.getName())).get());
            LOG.info((Object)("FINAL_SUM=" + FINAL_SUM));
        }

        private static void setFinalSum(long value) {
            FINAL_SUM = value;
        }

        public void preSuperstep() {
        }

        public void postSuperstep() {
        }

        public int getSupersteps() {
            return this.supersteps;
        }

        public boolean getEnableFault() {
            return this.enableFault;
        }
    }

    public static class SimpleCheckpointComputation
    extends BasicComputation<LongWritable, IntWritable, FloatWritable, FloatWritable> {
        public void compute(Vertex<LongWritable, IntWritable, FloatWritable> vertex, Iterable<FloatWritable> messages) throws IOException {
            SimpleCheckpointVertexWorkerContext workerContext = (SimpleCheckpointVertexWorkerContext)this.getWorkerContext();
            boolean enableFault = workerContext.getEnableFault();
            int supersteps = workerContext.getSupersteps();
            if (enableFault && this.getSuperstep() == 4L && this.getContext().getTaskAttemptID().getId() == 0 && ((LongWritable)vertex.getId()).get() == 1L) {
                LOG.info((Object)"compute: Forced a fault on the first attempt of superstep 4 and vertex id 1");
                System.exit(-1);
            }
            if (this.getSuperstep() > (long)supersteps) {
                vertex.voteToHalt();
                return;
            }
            long sumAgg = ((LongWritable)this.getAggregatedValue(LongSumAggregator.class.getName())).get();
            LOG.info((Object)("compute: " + sumAgg));
            this.aggregate(LongSumAggregator.class.getName(), (Writable)new LongWritable(((LongWritable)vertex.getId()).get()));
            LOG.info((Object)("compute: sum = " + sumAgg + " for vertex " + vertex.getId()));
            float msgValue = 0.0f;
            for (FloatWritable message : messages) {
                float curMsgValue = message.get();
                msgValue += curMsgValue;
                LOG.info((Object)("compute: got msgValue = " + curMsgValue + " for vertex " + vertex.getId() + " on superstep " + this.getSuperstep()));
            }
            int vertexValue = ((IntWritable)vertex.getValue()).get();
            vertex.setValue((Writable)new IntWritable(vertexValue + (int)msgValue));
            LOG.info((Object)("compute: vertex " + vertex.getId() + " has value " + vertex.getValue() + " on superstep " + this.getSuperstep()));
            for (Edge edge : vertex.getEdges()) {
                FloatWritable newEdgeValue = new FloatWritable(((FloatWritable)edge.getValue()).get() + (float)vertexValue);
                Edge newEdge = EdgeFactory.create((WritableComparable)edge.getTargetVertexId(), (Writable)newEdgeValue);
                LOG.info((Object)("compute: vertex " + vertex.getId() + " sending edgeValue " + edge.getValue() + " vertexValue " + vertexValue + " total " + newEdgeValue + " to vertex " + edge.getTargetVertexId() + " on superstep " + this.getSuperstep()));
                vertex.addEdge(newEdge);
                this.sendMessage(edge.getTargetVertexId(), (Writable)newEdgeValue);
            }
        }
    }
}

