/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.giraph.aggregators.AggregatorWriter;
import org.apache.giraph.conf.DefaultImmutableClassesGiraphConfigurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;

public class SimpleAggregatorWriter
extends DefaultImmutableClassesGiraphConfigurable
implements AggregatorWriter {
    private static String FILENAME;
    private FSDataOutputStream output;

    public static String getFilename() {
        return FILENAME;
    }

    public void initialize(Mapper.Context context, long applicationAttempt) throws IOException {
        SimpleAggregatorWriter.setFilename(applicationAttempt);
        Path p = new Path(FILENAME);
        FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
        this.output = fs.create(p, true);
    }

    private static void setFilename(long applicationAttempt) {
        FILENAME = "aggregatedValues_" + applicationAttempt;
    }

    public void writeAggregator(Iterable<Map.Entry<String, Writable>> aggregatorMap, long superstep) throws IOException {
        for (Map.Entry<String, Writable> entry : aggregatorMap) {
            entry.getValue().write((DataOutput)this.output);
        }
        this.output.flush();
    }

    public void close() throws IOException {
        this.output.close();
    }
}

