/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import com.google.common.collect.ImmutableSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Set;
import org.apache.giraph.examples.RandomWalkComputation;
import org.apache.giraph.examples.RandomWalkWithRestartComputation;
import org.apache.giraph.worker.WorkerContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class RandomWalkWorkerContext
extends WorkerContext {
    private static final int DEFAULT_MAX_SUPERSTEPS = 30;
    private static final float DEFAULT_TELEPORTATION_PROBABILITY = 0.15f;
    private static int MAX_SUPERSTEPS;
    private static double TELEPORTATION_PROBABILITY;
    private static Set<Long> SOURCES;
    private static final String SOURCE_VERTEX;
    private static final Logger LOG;

    public int getMaxSupersteps() {
        if (MAX_SUPERSTEPS == 0) {
            throw new IllegalStateException(RandomWalkWorkerContext.class.getSimpleName() + " was not initialized. Relaunch your job " + "by setting the appropriate WorkerContext");
        }
        return MAX_SUPERSTEPS;
    }

    public double getTeleportationProbability() {
        if (TELEPORTATION_PROBABILITY == 0.0) {
            throw new IllegalStateException(RandomWalkWorkerContext.class.getSimpleName() + " was not initialized. Relaunch your job " + "by setting the appropriate WorkerContext");
        }
        return TELEPORTATION_PROBABILITY;
    }

    public boolean isSource(long id) {
        return SOURCES.contains(id);
    }

    public int numSources() {
        return SOURCES.size();
    }

    private ImmutableSet<Long> initializeSources(Configuration configuration) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        long sourceVertex = configuration.getLong(SOURCE_VERTEX, Long.MIN_VALUE);
        if (sourceVertex != Long.MIN_VALUE) {
            return ImmutableSet.of((Object)sourceVertex);
        }
        Path sourceFile = null;
        try {
            String line;
            Path[] cacheFiles = DistributedCache.getLocalCacheFiles((Configuration)configuration);
            if (cacheFiles == null || cacheFiles.length == 0) {
                return ImmutableSet.of();
            }
            sourceFile = cacheFiles[0];
            LocalFileSystem fs = FileSystem.getLocal((Configuration)configuration);
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fs.open(sourceFile), Charset.defaultCharset()));
            while ((line = in.readLine()) != null) {
                builder.add((Object)Long.parseLong(line));
            }
            in.close();
        }
        catch (IOException e) {
            this.getContext().setStatus("Could not load local cache files: " + sourceFile);
            LOG.error((Object)("Could not load local cache files: " + sourceFile), (Throwable)e);
        }
        return builder.build();
    }

    public void preApplication() throws InstantiationException, IllegalAccessException {
        this.setStaticVars(this.getContext().getConfiguration());
    }

    private void setStaticVars(Configuration configuration) {
        MAX_SUPERSTEPS = configuration.getInt(RandomWalkComputation.MAX_SUPERSTEPS, 30);
        TELEPORTATION_PROBABILITY = configuration.getFloat(RandomWalkComputation.TELEPORTATION_PROBABILITY, 0.15f);
        SOURCES = this.initializeSources(configuration);
    }

    public void preSuperstep() {
    }

    public void postSuperstep() {
    }

    public void postApplication() {
    }

    static {
        SOURCE_VERTEX = RandomWalkWithRestartComputation.class.getName() + ".sourceVertex";
        LOG = Logger.getLogger(RandomWalkWorkerContext.class);
    }
}

