/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import com.google.common.base.Preconditions;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.examples.RandomWalkComputation;
import org.apache.giraph.examples.RandomWalkWorkerContext;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.utils.MathUtils;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;

public class RandomWalkWithRestartComputation
extends RandomWalkComputation<DoubleWritable> {
    static final String SOURCE_VERTEX = RandomWalkWithRestartComputation.class.getName() + ".sourceVertex";

    private boolean isSourceVertex(Vertex<LongWritable, ?, ?> vertex) {
        return ((RandomWalkWorkerContext)this.getWorkerContext()).isSource(((LongWritable)vertex.getId()).get());
    }

    private int numSourceVertices() {
        return ((RandomWalkWorkerContext)this.getWorkerContext()).numSources();
    }

    @Override
    protected double transitionProbability(Vertex<LongWritable, DoubleWritable, DoubleWritable> vertex, double stateProbability, Edge<LongWritable, DoubleWritable> edge) {
        return stateProbability * ((DoubleWritable)edge.getValue()).get();
    }

    @Override
    protected double recompute(Vertex<LongWritable, DoubleWritable, DoubleWritable> vertex, Iterable<DoubleWritable> transitionProbabilities, double teleportationProbability) {
        int numSourceVertices = this.numSourceVertices();
        Preconditions.checkState((numSourceVertices > 0 ? 1 : 0) != 0, (Object)"No source vertex found");
        double stateProbability = MathUtils.sum(transitionProbabilities);
        stateProbability += this.getDanglingProbability() / (double)this.getTotalNumVertices();
        stateProbability *= 1.0 - teleportationProbability;
        if (this.isSourceVertex(vertex)) {
            stateProbability += teleportationProbability / (double)numSourceVertices;
        }
        return stateProbability;
    }
}

