/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import org.apache.giraph.aggregators.DoubleSumAggregator;
import org.apache.giraph.aggregators.LongSumAggregator;
import org.apache.giraph.examples.RandomWalkComputation;
import org.apache.giraph.master.DefaultMasterCompute;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.log4j.Logger;

public class RandomWalkVertexMasterCompute
extends DefaultMasterCompute {
    static final double CONVERGENCE_THRESHOLD = 1.0E-5;
    private static final Logger LOG = Logger.getLogger(RandomWalkVertexMasterCompute.class);

    public void compute() {
        double danglingContribution = ((DoubleWritable)this.getAggregatedValue(RandomWalkComputation.CUMULATIVE_DANGLING_PROBABILITY)).get();
        double cumulativeProbability = ((DoubleWritable)this.getAggregatedValue(RandomWalkComputation.CUMULATIVE_PROBABILITY)).get();
        double l1NormOfStateDiff = ((DoubleWritable)this.getAggregatedValue(RandomWalkComputation.L1_NORM_OF_PROBABILITY_DIFFERENCE)).get();
        long numDanglingVertices = ((LongWritable)this.getAggregatedValue(RandomWalkComputation.NUM_DANGLING_VERTICES)).get();
        LOG.info((Object)("[Superstep " + this.getSuperstep() + "] Dangling contribution = " + danglingContribution + ", number of dangling vertices = " + numDanglingVertices + ", cumulative probability = " + cumulativeProbability + ", L1 Norm of state vector difference = " + l1NormOfStateDiff));
        if (this.getSuperstep() > 1L && l1NormOfStateDiff < 1.0E-5) {
            this.haltComputation();
        }
    }

    public void initialize() throws InstantiationException, IllegalAccessException {
        this.registerAggregator(RandomWalkComputation.NUM_DANGLING_VERTICES, LongSumAggregator.class);
        this.registerAggregator(RandomWalkComputation.CUMULATIVE_DANGLING_PROBABILITY, DoubleSumAggregator.class);
        this.registerAggregator(RandomWalkComputation.CUMULATIVE_PROBABILITY, DoubleSumAggregator.class);
        this.registerAggregator(RandomWalkComputation.L1_NORM_OF_PROBABILITY_DIFFERENCE, DoubleSumAggregator.class);
    }
}

