/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import java.io.IOException;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.examples.RandomWalkWorkerContext;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;

public abstract class RandomWalkComputation<E extends Writable>
extends BasicComputation<LongWritable, DoubleWritable, E, DoubleWritable> {
    static final String MAX_SUPERSTEPS = RandomWalkComputation.class.getName() + ".maxSupersteps";
    static final String TELEPORTATION_PROBABILITY = RandomWalkComputation.class.getName() + ".teleportationProbability";
    static final String CUMULATIVE_DANGLING_PROBABILITY = RandomWalkComputation.class.getName() + ".cumulativeDanglingProbability";
    static final String CUMULATIVE_PROBABILITY = RandomWalkComputation.class.getName() + ".cumulativeProbability";
    static final String NUM_DANGLING_VERTICES = RandomWalkComputation.class.getName() + ".numDanglingVertices";
    static final String L1_NORM_OF_PROBABILITY_DIFFERENCE = RandomWalkComputation.class.getName() + ".l1NormOfProbabilityDifference";
    private final DoubleWritable doubleWritable = new DoubleWritable();
    private final LongWritable one = new LongWritable(1L);

    protected double initialProbability() {
        return 1.0 / (double)this.getTotalNumVertices();
    }

    protected abstract double transitionProbability(Vertex<LongWritable, DoubleWritable, E> var1, double var2, Edge<LongWritable, E> var4);

    protected abstract double recompute(Vertex<LongWritable, DoubleWritable, E> var1, Iterable<DoubleWritable> var2, double var3);

    protected double getDanglingProbability() {
        return ((DoubleWritable)this.getAggregatedValue(CUMULATIVE_DANGLING_PROBABILITY)).get();
    }

    protected double getPreviousCumulativeProbability() {
        return ((DoubleWritable)this.getAggregatedValue(CUMULATIVE_PROBABILITY)).get();
    }

    public void compute(Vertex<LongWritable, DoubleWritable, E> vertex, Iterable<DoubleWritable> messages) throws IOException {
        double stateProbability;
        if (this.getSuperstep() > 0L) {
            double previousStateProbability = ((DoubleWritable)vertex.getValue()).get();
            stateProbability = this.recompute(vertex, messages, this.teleportationProbability());
            this.doubleWritable.set(Math.abs((stateProbability /= this.getPreviousCumulativeProbability()) - previousStateProbability));
            this.aggregate(L1_NORM_OF_PROBABILITY_DIFFERENCE, (Writable)this.doubleWritable);
        } else {
            stateProbability = this.initialProbability();
        }
        ((DoubleWritable)vertex.getValue()).set(stateProbability);
        this.aggregate(CUMULATIVE_PROBABILITY, vertex.getValue());
        if (vertex.getNumEdges() == 0) {
            this.aggregate(NUM_DANGLING_VERTICES, (Writable)this.one);
            this.aggregate(CUMULATIVE_DANGLING_PROBABILITY, vertex.getValue());
        }
        if (this.getSuperstep() < (long)this.maxSupersteps()) {
            for (Edge edge : vertex.getEdges()) {
                double transitionProbability = this.transitionProbability(vertex, stateProbability, edge);
                this.doubleWritable.set(transitionProbability);
                this.sendMessage(edge.getTargetVertexId(), (Writable)this.doubleWritable);
            }
        } else {
            vertex.voteToHalt();
        }
    }

    private int maxSupersteps() {
        return ((RandomWalkWorkerContext)this.getWorkerContext()).getMaxSupersteps();
    }

    protected double teleportationProbability() {
        return ((RandomWalkWorkerContext)this.getWorkerContext()).getTeleportationProbability();
    }
}

