/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import org.apache.giraph.edge.Edge;
import org.apache.giraph.examples.RandomWalkComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.utils.MathUtils;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;

public class PageRankComputation
extends RandomWalkComputation<NullWritable> {
    @Override
    protected double transitionProbability(Vertex<LongWritable, DoubleWritable, NullWritable> vertex, double stateProbability, Edge<LongWritable, NullWritable> edge) {
        return stateProbability / (double)vertex.getNumEdges();
    }

    @Override
    protected double recompute(Vertex<LongWritable, DoubleWritable, NullWritable> vertex, Iterable<DoubleWritable> partialRanks, double teleportationProbability) {
        double rankFromNeighbors = MathUtils.sum(partialRanks);
        double danglingContribution = this.getDanglingProbability() / (double)this.getTotalNumVertices();
        return (1.0 - teleportationProbability) * (rankFromNeighbors + danglingContribution) + teleportationProbability / (double)this.getTotalNumVertices();
    }
}

