/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.giraph.conf.ImmutableClassesGiraphConfigurable;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.formats.TextVertexInputFormat;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class NormalizingLongDoubleDoubleTextInputFormat
extends TextVertexInputFormat<LongWritable, DoubleWritable, DoubleWritable>
implements ImmutableClassesGiraphConfigurable<LongWritable, DoubleWritable, DoubleWritable> {
    private ImmutableClassesGiraphConfiguration<LongWritable, DoubleWritable, DoubleWritable> conf;

    public TextVertexInputFormat.TextVertexReader createVertexReader(InputSplit split, TaskAttemptContext context) throws IOException {
        return new NormalizingLongDoubleDoubleDoubleVertexReader();
    }

    public void setConf(ImmutableClassesGiraphConfiguration<LongWritable, DoubleWritable, DoubleWritable> configuration) {
        this.conf = configuration;
    }

    public ImmutableClassesGiraphConfiguration<LongWritable, DoubleWritable, DoubleWritable> getConf() {
        return this.conf;
    }

    public class NormalizingLongDoubleDoubleDoubleVertexReader
    extends TextVertexInputFormat.TextVertexReader {
        private final Pattern edgeSeparator;
        private final Pattern weightSeparator;

        public NormalizingLongDoubleDoubleDoubleVertexReader() {
            super((TextVertexInputFormat)NormalizingLongDoubleDoubleTextInputFormat.this);
            this.edgeSeparator = Pattern.compile("\\s+");
            this.weightSeparator = Pattern.compile(":");
        }

        public Vertex<LongWritable, DoubleWritable, DoubleWritable> getCurrentVertex() throws IOException, InterruptedException {
            Vertex vertex = NormalizingLongDoubleDoubleTextInputFormat.this.conf.createVertex();
            String[] tokens = this.edgeSeparator.split(((Text)this.getRecordReader().getCurrentValue()).toString());
            ArrayList edges = Lists.newArrayListWithCapacity((int)(tokens.length - 1));
            this.parse(tokens, edges);
            this.normalize(edges);
            LongWritable vertexId = new LongWritable(Long.parseLong(tokens[0]));
            vertex.initialize((WritableComparable)vertexId, (Writable)new DoubleWritable(), (Iterable)edges);
            return vertex;
        }

        void parse(String[] tokens, Collection<Edge<LongWritable, DoubleWritable>> edges) {
            for (int n = 1; n < tokens.length; ++n) {
                String[] parts = this.weightSeparator.split(tokens[n]);
                edges.add((Edge<LongWritable, DoubleWritable>)EdgeFactory.create((WritableComparable)new LongWritable(Long.parseLong(parts[0])), (Writable)new DoubleWritable(Double.parseDouble(parts[1]))));
            }
        }

        void normalize(Collection<Edge<LongWritable, DoubleWritable>> edges) {
            if (edges == null || edges.size() == 0) {
                throw new IllegalArgumentException("Cannot normalize an empy set of edges");
            }
            float normalizer = 0.0f;
            for (Edge<LongWritable, DoubleWritable> edge : edges) {
                normalizer = (float)((double)normalizer + ((DoubleWritable)edge.getValue()).get());
            }
            for (Edge<LongWritable, DoubleWritable> edge : edges) {
                ((DoubleWritable)edge.getValue()).set(((DoubleWritable)edge.getValue()).get() / (double)normalizer);
            }
        }

        public boolean nextVertex() throws IOException, InterruptedException {
            return this.getRecordReader().nextKeyValue();
        }
    }
}

