/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.giraph.conf.ImmutableClassesGiraphConfigurable;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.formats.TextVertexInputFormat;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class LongDoubleNullTextInputFormat
extends TextVertexInputFormat<LongWritable, DoubleWritable, NullWritable>
implements ImmutableClassesGiraphConfigurable<LongWritable, DoubleWritable, NullWritable> {
    private ImmutableClassesGiraphConfiguration<LongWritable, DoubleWritable, NullWritable> conf;

    public TextVertexInputFormat.TextVertexReader createVertexReader(InputSplit split, TaskAttemptContext context) throws IOException {
        return new LongDoubleNullDoubleVertexReader();
    }

    public void setConf(ImmutableClassesGiraphConfiguration<LongWritable, DoubleWritable, NullWritable> configuration) {
        this.conf = configuration;
    }

    public ImmutableClassesGiraphConfiguration<LongWritable, DoubleWritable, NullWritable> getConf() {
        return this.conf;
    }

    public class LongDoubleNullDoubleVertexReader
    extends TextVertexInputFormat.TextVertexReader {
        private final Pattern separator;

        public LongDoubleNullDoubleVertexReader() {
            super((TextVertexInputFormat)LongDoubleNullTextInputFormat.this);
            this.separator = Pattern.compile("[\t ]");
        }

        public Vertex<LongWritable, DoubleWritable, NullWritable> getCurrentVertex() throws IOException, InterruptedException {
            Vertex vertex = LongDoubleNullTextInputFormat.this.conf.createVertex();
            String[] tokens = this.separator.split(((Text)this.getRecordReader().getCurrentValue()).toString());
            ArrayList edges = Lists.newArrayListWithCapacity((int)(tokens.length - 1));
            for (int n = 1; n < tokens.length; ++n) {
                edges.add(EdgeFactory.create((WritableComparable)new LongWritable(Long.parseLong(tokens[n])), (Writable)NullWritable.get()));
            }
            LongWritable vertexId = new LongWritable(Long.parseLong(tokens[0]));
            vertex.initialize((WritableComparable)vertexId, (Writable)new DoubleWritable(), (Iterable)edges);
            return vertex;
        }

        public boolean nextVertex() throws IOException, InterruptedException {
            return this.getRecordReader().nextKeyValue();
        }
    }
}

