/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.giraph.conf.ImmutableClassesGiraphConfigurable;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.formats.TextVertexInputFormat;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class LongDoubleFloatTextInputFormat
extends TextVertexInputFormat<LongWritable, DoubleWritable, FloatWritable>
implements ImmutableClassesGiraphConfigurable<LongWritable, DoubleWritable, FloatWritable> {
    private ImmutableClassesGiraphConfiguration<LongWritable, DoubleWritable, FloatWritable> conf;

    public TextVertexInputFormat.TextVertexReader createVertexReader(InputSplit split, TaskAttemptContext context) throws IOException {
        return new LongDoubleFloatVertexReader();
    }

    public void setConf(ImmutableClassesGiraphConfiguration<LongWritable, DoubleWritable, FloatWritable> configuration) {
        this.conf = configuration;
    }

    public ImmutableClassesGiraphConfiguration<LongWritable, DoubleWritable, FloatWritable> getConf() {
        return this.conf;
    }

    public class LongDoubleFloatVertexReader
    extends TextVertexInputFormat.TextVertexReader {
        private final Pattern neighborSeparator;
        private final Pattern weightSeparator;

        public LongDoubleFloatVertexReader() {
            super((TextVertexInputFormat)LongDoubleFloatTextInputFormat.this);
            this.neighborSeparator = Pattern.compile("[\t ]");
            this.weightSeparator = Pattern.compile("[:]");
        }

        public Vertex<LongWritable, DoubleWritable, FloatWritable> getCurrentVertex() throws IOException, InterruptedException {
            Vertex vertex = LongDoubleFloatTextInputFormat.this.conf.createVertex();
            String[] tokens = this.neighborSeparator.split(((Text)this.getRecordReader().getCurrentValue()).toString());
            ArrayList edges = Lists.newArrayListWithCapacity((int)(tokens.length - 1));
            for (int n = 1; n < tokens.length; ++n) {
                String[] parts = this.weightSeparator.split(tokens[n]);
                edges.add(EdgeFactory.create((WritableComparable)new LongWritable(Long.parseLong(parts[0])), (Writable)new FloatWritable(Float.parseFloat(parts[1]))));
            }
            LongWritable vertexId = new LongWritable(Long.parseLong(tokens[0]));
            vertex.initialize((WritableComparable)vertexId, (Writable)new DoubleWritable(), (Iterable)edges);
            return vertex;
        }

        public boolean nextVertex() throws IOException, InterruptedException {
            return this.getRecordReader().nextKeyValue();
        }
    }
}

