/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.giraph.conf.ImmutableClassesGiraphConfigurable;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.formats.TextVertexInputFormat;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class LongDoubleDoubleTextInputFormat
extends TextVertexInputFormat<LongWritable, DoubleWritable, DoubleWritable>
implements ImmutableClassesGiraphConfigurable<LongWritable, DoubleWritable, DoubleWritable> {
    private ImmutableClassesGiraphConfiguration<LongWritable, DoubleWritable, DoubleWritable> conf;

    public TextVertexInputFormat.TextVertexReader createVertexReader(InputSplit split, TaskAttemptContext context) throws IOException {
        return new LongDoubleDoubleDoubleVertexReader();
    }

    public void setConf(ImmutableClassesGiraphConfiguration<LongWritable, DoubleWritable, DoubleWritable> configuration) {
        this.conf = configuration;
    }

    public ImmutableClassesGiraphConfiguration<LongWritable, DoubleWritable, DoubleWritable> getConf() {
        return this.conf;
    }

    public class LongDoubleDoubleDoubleVertexReader
    extends TextVertexInputFormat.TextVertexReader {
        private final Pattern separator;

        public LongDoubleDoubleDoubleVertexReader() {
            super((TextVertexInputFormat)LongDoubleDoubleTextInputFormat.this);
            this.separator = Pattern.compile("[\t ]");
        }

        public Vertex<LongWritable, DoubleWritable, DoubleWritable> getCurrentVertex() throws IOException, InterruptedException {
            Vertex vertex = LongDoubleDoubleTextInputFormat.this.conf.createVertex();
            String[] tokens = this.separator.split(((Text)this.getRecordReader().getCurrentValue()).toString());
            ArrayList edges = Lists.newArrayListWithCapacity((int)(tokens.length - 1));
            float weight = 1.0f / (float)(tokens.length - 1);
            for (int n = 1; n < tokens.length; ++n) {
                edges.add(EdgeFactory.create((WritableComparable)new LongWritable(Long.parseLong(tokens[n])), (Writable)new DoubleWritable((double)weight)));
            }
            LongWritable vertexId = new LongWritable(Long.parseLong(tokens[0]));
            vertex.initialize((WritableComparable)vertexId, (Writable)new DoubleWritable(), (Iterable)edges);
            return vertex;
        }

        public boolean nextVertex() throws IOException, InterruptedException {
            return this.getRecordReader().nextKeyValue();
        }
    }
}

