/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import java.io.IOException;
import org.apache.giraph.bsp.BspInputSplit;
import org.apache.giraph.conf.BooleanConfOption;
import org.apache.giraph.conf.LongConfOption;
import org.apache.giraph.io.VertexReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public abstract class GeneratedVertexReader<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexReader<I, V, E> {
    public static final LongConfOption READER_VERTICES = new LongConfOption("GeneratedVertexReader.reader_vertices", 10L, "Vertices produced by this reader");
    public static final BooleanConfOption REVERSE_ID_ORDER = new BooleanConfOption("GeneratedVertexReader.reverseIdOrder", false, "Reverse the order of the vertices?");
    protected long recordsRead = 0L;
    protected long totalRecords = 0L;
    protected BspInputSplit inputSplit = null;
    protected boolean reverseIdOrder;

    public final void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException {
        this.totalRecords = READER_VERTICES.get((Configuration)this.getConf());
        this.reverseIdOrder = REVERSE_ID_ORDER.get((Configuration)this.getConf());
        this.inputSplit = (BspInputSplit)inputSplit;
    }

    public void close() throws IOException {
    }

    public final float getProgress() throws IOException {
        return (float)this.recordsRead * 100.0f / (float)this.totalRecords;
    }
}

