/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import java.io.IOException;
import org.apache.giraph.bsp.BspInputSplit;
import org.apache.giraph.conf.LongConfOption;
import org.apache.giraph.io.EdgeReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public abstract class GeneratedEdgeReader<I extends WritableComparable, E extends Writable>
extends EdgeReader<I, E> {
    public static final LongConfOption DEFAULT_READER_EDGES = new LongConfOption("GeneratedEdgeReader.reader_edges", 10L, "Default edges produced by this reader");
    protected long recordsRead = 0L;
    protected long totalRecords = 0L;
    protected BspInputSplit inputSplit = null;

    public final void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException {
        this.totalRecords = DEFAULT_READER_EDGES.get((Configuration)this.getConf());
        this.inputSplit = (BspInputSplit)inputSplit;
    }

    public void close() throws IOException {
    }

    public final float getProgress() throws IOException {
        return (float)this.recordsRead * 100.0f / (float)this.totalRecords;
    }
}

