/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import java.io.IOException;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.examples.Algorithm;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

@Algorithm(name="Connected components", description="Finds connected components of the graph")
public class ConnectedComponentsComputation
extends BasicComputation<IntWritable, IntWritable, NullWritable, IntWritable> {
    public void compute(Vertex<IntWritable, IntWritable, NullWritable> vertex, Iterable<IntWritable> messages) throws IOException {
        int currentComponent = ((IntWritable)vertex.getValue()).get();
        if (this.getSuperstep() == 0L) {
            for (Edge edge : vertex.getEdges()) {
                int neighbor = ((IntWritable)edge.getTargetVertexId()).get();
                if (neighbor >= currentComponent) continue;
                currentComponent = neighbor;
            }
            if (currentComponent != ((IntWritable)vertex.getValue()).get()) {
                vertex.setValue((Writable)new IntWritable(currentComponent));
                for (Edge edge : vertex.getEdges()) {
                    IntWritable neighbor = (IntWritable)edge.getTargetVertexId();
                    if (neighbor.get() <= currentComponent) continue;
                    this.sendMessage((WritableComparable)neighbor, vertex.getValue());
                }
            }
            vertex.voteToHalt();
            return;
        }
        boolean changed = false;
        for (IntWritable message : messages) {
            int candidateComponent = message.get();
            if (candidateComponent >= currentComponent) continue;
            currentComponent = candidateComponent;
            changed = true;
        }
        if (changed) {
            vertex.setValue((Writable)new IntWritable(currentComponent));
            this.sendMessageToAllEdges(vertex, vertex.getValue());
        }
        vertex.voteToHalt();
    }
}

