/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.giraph.conf.LongConfOption;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.examples.Algorithm;
import org.apache.giraph.examples.utils.BrachaTouegDeadlockMessage;
import org.apache.giraph.examples.utils.BrachaTouegDeadlockVertexValue;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

@Algorithm(name="Bracha Toueg deadlock detection")
public class BrachaTouegDeadlockComputation
extends BasicComputation<LongWritable, BrachaTouegDeadlockVertexValue, LongWritable, BrachaTouegDeadlockMessage> {
    public static final LongConfOption BRACHA_TOUEG_DL_INITIATOR_ID = new LongConfOption("BrachaTouegDeadlockVertex.initiatorId", 1L, "The deadlock detection initiator id");
    private static final Logger LOG = Logger.getLogger(BrachaTouegDeadlockComputation.class);

    /*
     * Enabled aggressive block sorting
     */
    public void compute(Vertex<LongWritable, BrachaTouegDeadlockVertexValue, LongWritable> vertex, Iterable<BrachaTouegDeadlockMessage> messages) throws IOException {
        long superstep = this.getSuperstep();
        if (superstep == 0L) {
            this.initAlgorithm(vertex);
            return;
        }
        if (superstep == 1L) {
            BrachaTouegDeadlockVertexValue value = (BrachaTouegDeadlockVertexValue)vertex.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Vertex ID " + vertex.getId() + " status is:"));
                LOG.debug((Object)("\tpending requests? " + value.hasPendingRequests()));
                LOG.debug((Object)("\tis free? " + value.isFree()));
                LOG.debug((Object)("\tis notified? " + value.isNotified()));
            }
            for (BrachaTouegDeadlockMessage message : messages) {
                value.addParent(message.getSenderId());
            }
            if (LOG.isDebugEnabled()) {
                this.logParents(vertex);
                if (this.isInitiator(vertex)) {
                    LOG.debug((Object)("Vertex ID " + vertex.getId() + " start the algorithm."));
                }
            }
            if (this.isInitiator(vertex)) {
                this.notifyVertices(vertex);
                return;
            }
            vertex.voteToHalt();
            return;
        }
        BrachaTouegDeadlockVertexValue value = (BrachaTouegDeadlockVertexValue)vertex.getValue();
        for (BrachaTouegDeadlockMessage message : messages) {
            long type = message.getType();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Vertex ID " + vertex.getId() + " received: " + message));
            }
            if (type == 1L) {
                this.handleNotifyMessage(vertex, message);
                continue;
            }
            if (type == 2L) {
                this.handleGrantMessage(vertex, message);
                continue;
            }
            if (type != 8L && type != 4L) continue;
            value.receivedMessage(message.getSenderId(), message.getType());
        }
        Long ackSenderId = value.getIdWithInHoldAck();
        if (value.isFree() && !value.isWaitingForMessage(4L) && !ackSenderId.equals(BrachaTouegDeadlockVertexValue.INVALID_ID)) {
            this.sendAckMessage(ackSenderId, vertex);
            value.setIdWithInHoldAck(BrachaTouegDeadlockVertexValue.INVALID_ID);
        }
        if (!value.isNotified()) return;
        if (value.isWaitingForMessage(4L)) return;
        if (value.isWaitingForMessage(8L)) return;
        Long senderId = value.getIdWithInHoldDone();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Vertex ID " + vertex.getId() + " sent the last DONE message."));
            LOG.debug((Object)("Vertex ID " + vertex.getId() + " voted to halt."));
        }
        if (!this.isInitiator(vertex) && !senderId.equals(BrachaTouegDeadlockVertexValue.INVALID_ID)) {
            this.sendMessage(((LongWritable)vertex.getId()).get(), senderId, 8L);
            value.setIdWithInHoldDone(BrachaTouegDeadlockVertexValue.INVALID_ID);
        }
        vertex.voteToHalt();
    }

    private boolean isInitiator(Vertex<LongWritable, ?, ?> vertex) {
        return ((LongWritable)vertex.getId()).get() == BRACHA_TOUEG_DL_INITIATOR_ID.get((Configuration)this.getConf());
    }

    private void initAlgorithm(Vertex<LongWritable, BrachaTouegDeadlockVertexValue, LongWritable> vertex) {
        HashMap<Long, ArrayList<Long>> requests = new HashMap<Long, ArrayList<Long>>();
        long vertexId = ((LongWritable)vertex.getId()).get();
        for (Edge edge : vertex.getEdges()) {
            Long tag = ((LongWritable)edge.getValue()).get();
            Long target = ((LongWritable)edge.getTargetVertexId()).get();
            ArrayList<Object> targets = requests.containsKey(tag) ? requests.get(tag) : new ArrayList();
            targets.add(target);
            requests.put(tag, targets);
        }
        BrachaTouegDeadlockVertexValue value = new BrachaTouegDeadlockVertexValue(requests);
        vertex.setValue((Writable)value);
        for (Edge edge : vertex.getEdges()) {
            this.sendMessage(vertexId, ((LongWritable)edge.getTargetVertexId()).get(), 16L);
        }
    }

    private void sendAckMessage(long receiver, Vertex<LongWritable, BrachaTouegDeadlockVertexValue, LongWritable> vertex) {
        this.sendMessage(((LongWritable)vertex.getId()).get(), receiver, 4L);
        if (!((BrachaTouegDeadlockVertexValue)vertex.getValue()).isNotified()) {
            vertex.voteToHalt();
        }
    }

    private void sendMessage(long sender, long receiver, long messageType) {
        BrachaTouegDeadlockMessage message = new BrachaTouegDeadlockMessage(sender, messageType);
        this.sendMessage((WritableComparable)new LongWritable(receiver), message);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("sent message " + message + " from " + sender + " to " + receiver));
        }
    }

    private void logParents(Vertex<LongWritable, BrachaTouegDeadlockVertexValue, LongWritable> vertex) {
        ArrayList<Long> parents = ((BrachaTouegDeadlockVertexValue)vertex.getValue()).getParents();
        int sz = parents.size();
        StringBuffer buffer = new StringBuffer();
        buffer.append("Vertex " + vertex.getId() + " parents:");
        for (int i = 0; i < sz; ++i) {
            buffer.append(" - " + parents.get(i));
        }
        LOG.debug((Object)buffer.toString());
    }

    private void notifyVertices(Vertex<LongWritable, BrachaTouegDeadlockVertexValue, LongWritable> vertex) {
        BrachaTouegDeadlockVertexValue value = (BrachaTouegDeadlockVertexValue)vertex.getValue();
        long vertexId = ((LongWritable)vertex.getId()).get();
        boolean hasOutEdges = false;
        value.setNotified();
        for (Edge edge : vertex.getEdges()) {
            hasOutEdges = true;
            this.sendMessage(vertexId, ((LongWritable)edge.getTargetVertexId()).get(), 1L);
            value.waitForMessage(((LongWritable)edge.getTargetVertexId()).get(), 8L);
        }
        if (!hasOutEdges && this.isInitiator(vertex)) {
            value.setFree();
        } else if (!value.hasPendingRequests() && !value.isFree()) {
            this.grantVertices(vertex);
        }
    }

    private void grantVertices(Vertex<LongWritable, BrachaTouegDeadlockVertexValue, LongWritable> vertex) {
        BrachaTouegDeadlockVertexValue value = (BrachaTouegDeadlockVertexValue)vertex.getValue();
        ArrayList<Long> parents = value.getParents();
        long vertexId = ((LongWritable)vertex.getId()).get();
        value.setFree();
        for (Long parent : parents) {
            this.sendMessage(vertexId, parent, 2L);
            value.waitForMessage(parent, 4L);
        }
    }

    private void handleNotifyMessage(Vertex<LongWritable, BrachaTouegDeadlockVertexValue, LongWritable> vertex, BrachaTouegDeadlockMessage message) {
        BrachaTouegDeadlockVertexValue value = (BrachaTouegDeadlockVertexValue)vertex.getValue();
        if (!value.isNotified()) {
            this.notifyVertices(vertex);
            value.setIdWithInHoldDone(message.getSenderId());
        } else {
            this.sendMessage(((LongWritable)vertex.getId()).get(), message.getSenderId(), 8L);
        }
    }

    private void handleGrantMessage(Vertex<LongWritable, BrachaTouegDeadlockVertexValue, LongWritable> vertex, BrachaTouegDeadlockMessage message) {
        BrachaTouegDeadlockVertexValue value = (BrachaTouegDeadlockVertexValue)vertex.getValue();
        Long senderId = message.getSenderId();
        LongWritable wId = new LongWritable(senderId.longValue());
        LongWritable tag = (LongWritable)vertex.getEdgeValue((WritableComparable)wId);
        value.removeRequest(tag, wId);
        if (value.isFree() || value.getNumOfRequests(tag) > 0) {
            this.sendAckMessage(senderId, vertex);
            return;
        }
        this.grantVertices(vertex);
        value.setIdWithInHoldAck(senderId);
    }
}

