/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.giraph.aggregators.LongSumAggregator;
import org.apache.giraph.bsp.BspInputSplit;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.examples.GeneratedEdgeReader;
import org.apache.giraph.examples.GeneratedVertexReader;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.EdgeInputFormat;
import org.apache.giraph.io.EdgeReader;
import org.apache.giraph.io.VertexReader;
import org.apache.giraph.io.formats.GeneratedVertexInputFormat;
import org.apache.giraph.master.DefaultMasterCompute;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;

public class AggregatorsTestComputation
extends BasicComputation<LongWritable, DoubleWritable, FloatWritable, DoubleWritable> {
    private static final String REGULAR_AGG = "regular";
    private static final String PERSISTENT_AGG = "persistent";
    private static final String INPUT_VERTEX_PERSISTENT_AGG = "input_super_step_vertex_agg";
    private static final String INPUT_EDGE_PERSISTENT_AGG = "input_super_step_edge_agg";
    private static final String MASTER_WRITE_AGG = "master";
    private static final long MASTER_VALUE = 12345L;
    private static final String ARRAY_PREFIX_AGG = "array";
    private static final int NUM_OF_AGGREGATORS_IN_ARRAY = 100;

    public void compute(Vertex<LongWritable, DoubleWritable, FloatWritable> vertex, Iterable<DoubleWritable> messages) throws IOException {
        long superstep = this.getSuperstep();
        LongWritable myValue = new LongWritable(1L << (int)superstep);
        this.aggregate(REGULAR_AGG, (Writable)myValue);
        this.aggregate(PERSISTENT_AGG, (Writable)myValue);
        long nv = this.getTotalNumVertices();
        if (superstep > 0L) {
            AggregatorsTestComputation.assertEquals(nv * (1L << (int)(superstep - 1L)), ((LongWritable)this.getAggregatedValue(REGULAR_AGG)).get());
        } else {
            AggregatorsTestComputation.assertEquals(0L, ((LongWritable)this.getAggregatedValue(REGULAR_AGG)).get());
        }
        AggregatorsTestComputation.assertEquals(nv * ((1L << (int)superstep) - 1L), ((LongWritable)this.getAggregatedValue(PERSISTENT_AGG)).get());
        AggregatorsTestComputation.assertEquals(12345L * (1L << (int)superstep), ((LongWritable)this.getAggregatedValue(MASTER_WRITE_AGG)).get());
        for (int i = 0; i < 100; ++i) {
            this.aggregate(ARRAY_PREFIX_AGG + i, (Writable)new LongWritable((superstep + 1L) * (long)i));
            AggregatorsTestComputation.assertEquals(superstep * this.getTotalNumVertices() * (long)i, ((LongWritable)this.getAggregatedValue(ARRAY_PREFIX_AGG + i)).get());
        }
        if (this.getSuperstep() == 10L) {
            vertex.voteToHalt();
        }
    }

    private static void assertEquals(long expected, long actual) {
        if (expected != actual) {
            throw new RuntimeException("expected: " + expected + ", actual: " + actual);
        }
    }

    public static class SimpleEdgeInputFormat
    extends EdgeInputFormat<LongWritable, FloatWritable> {
        public void checkInputSpecs(Configuration conf) {
        }

        public EdgeReader<LongWritable, FloatWritable> createEdgeReader(InputSplit split, TaskAttemptContext context) throws IOException {
            return new SimpleEdgeReader();
        }

        public List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
            ArrayList<InputSplit> inputSplitList = new ArrayList<InputSplit>();
            for (int i = 0; i < minSplitCountHint; ++i) {
                inputSplitList.add((InputSplit)new BspInputSplit(i, minSplitCountHint));
            }
            return inputSplitList;
        }
    }

    public static class SimpleEdgeReader
    extends GeneratedEdgeReader<LongWritable, FloatWritable> {
        private static final Logger LOG = Logger.getLogger(SimpleEdgeReader.class);

        public boolean nextEdge() {
            return this.totalRecords > this.recordsRead;
        }

        public Edge<LongWritable, FloatWritable> getCurrentEdge() throws IOException {
            LongWritable vertexId = new LongWritable((long)this.inputSplit.getSplitIndex() * this.totalRecords + this.recordsRead);
            long targetVertexId = (vertexId.get() + 1L) % ((long)this.inputSplit.getNumSplits() * this.totalRecords);
            float edgeValue = (float)vertexId.get() * 100.0f;
            Edge edge = EdgeFactory.create((WritableComparable)new LongWritable(targetVertexId), (Writable)new FloatWritable(edgeValue));
            ++this.recordsRead;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("next edge: Return targetVertexId=" + targetVertexId + ", edgeValue=" + edgeValue));
            }
            this.aggregate(AggregatorsTestComputation.INPUT_EDGE_PERSISTENT_AGG, (Writable)new LongWritable((long)((FloatWritable)edge.getValue()).get()));
            return edge;
        }

        public LongWritable getCurrentSourceId() throws IOException, InterruptedException {
            LongWritable vertexId = new LongWritable((long)this.inputSplit.getSplitIndex() * this.totalRecords + this.recordsRead);
            return vertexId;
        }
    }

    public static class SimpleVertexInputFormat
    extends GeneratedVertexInputFormat<LongWritable, DoubleWritable, FloatWritable> {
        public VertexReader<LongWritable, DoubleWritable, FloatWritable> createVertexReader(InputSplit split, TaskAttemptContext context) throws IOException {
            return new SimpleVertexReader();
        }
    }

    public static class SimpleVertexReader
    extends GeneratedVertexReader<LongWritable, DoubleWritable, FloatWritable> {
        private static final Logger LOG = Logger.getLogger(SimpleVertexReader.class);

        public boolean nextVertex() {
            return this.totalRecords > this.recordsRead;
        }

        public Vertex<LongWritable, DoubleWritable, FloatWritable> getCurrentVertex() throws IOException {
            Vertex vertex = this.getConf().createVertex();
            LongWritable vertexId = new LongWritable((long)this.inputSplit.getSplitIndex() * this.totalRecords + this.recordsRead);
            DoubleWritable vertexValue = new DoubleWritable((double)vertexId.get() * 10.0);
            long targetVertexId = (vertexId.get() + 1L) % ((long)this.inputSplit.getNumSplits() * this.totalRecords);
            float edgeValue = (float)vertexId.get() * 100.0f;
            LinkedList edges = Lists.newLinkedList();
            edges.add(EdgeFactory.create((WritableComparable)new LongWritable(targetVertexId), (Writable)new FloatWritable(edgeValue)));
            vertex.initialize((WritableComparable)vertexId, (Writable)vertexValue, (Iterable)edges);
            ++this.recordsRead;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("next vertex: Return vertexId=" + ((LongWritable)vertex.getId()).get() + ", vertexValue=" + vertex.getValue() + ", targetVertexId=" + targetVertexId + ", edgeValue=" + edgeValue));
            }
            this.aggregate(AggregatorsTestComputation.INPUT_VERTEX_PERSISTENT_AGG, (Writable)new LongWritable((long)((DoubleWritable)vertex.getValue()).get()));
            return vertex;
        }
    }

    public static class AggregatorsTestMasterCompute
    extends DefaultMasterCompute {
        public void compute() {
            long superstep = this.getSuperstep();
            LongWritable myValue = new LongWritable(12345L * (1L << (int)superstep));
            this.setAggregatedValue(AggregatorsTestComputation.MASTER_WRITE_AGG, (Writable)myValue);
            long nv = this.getTotalNumVertices();
            if (superstep >= 0L) {
                AggregatorsTestComputation.assertEquals(100L, ((LongWritable)this.getAggregatedValue(AggregatorsTestComputation.INPUT_VERTEX_PERSISTENT_AGG)).get());
            }
            if (superstep >= 0L) {
                AggregatorsTestComputation.assertEquals(4500L, ((LongWritable)this.getAggregatedValue(AggregatorsTestComputation.INPUT_EDGE_PERSISTENT_AGG)).get());
            }
            if (superstep > 0L) {
                AggregatorsTestComputation.assertEquals(nv * (1L << (int)(superstep - 1L)), ((LongWritable)this.getAggregatedValue(AggregatorsTestComputation.REGULAR_AGG)).get());
            } else {
                AggregatorsTestComputation.assertEquals(0L, ((LongWritable)this.getAggregatedValue(AggregatorsTestComputation.REGULAR_AGG)).get());
            }
            AggregatorsTestComputation.assertEquals(nv * ((1L << (int)superstep) - 1L), ((LongWritable)this.getAggregatedValue(AggregatorsTestComputation.PERSISTENT_AGG)).get());
            for (int i = 0; i < 100; ++i) {
                AggregatorsTestComputation.assertEquals(superstep * this.getTotalNumVertices() * (long)i, ((LongWritable)this.getAggregatedValue(AggregatorsTestComputation.ARRAY_PREFIX_AGG + i)).get());
            }
        }

        public void initialize() throws InstantiationException, IllegalAccessException {
            this.registerPersistentAggregator(AggregatorsTestComputation.INPUT_VERTEX_PERSISTENT_AGG, LongSumAggregator.class);
            this.registerPersistentAggregator(AggregatorsTestComputation.INPUT_EDGE_PERSISTENT_AGG, LongSumAggregator.class);
            this.registerAggregator(AggregatorsTestComputation.REGULAR_AGG, LongSumAggregator.class);
            this.registerPersistentAggregator(AggregatorsTestComputation.PERSISTENT_AGG, LongSumAggregator.class);
            this.registerAggregator(AggregatorsTestComputation.MASTER_WRITE_AGG, LongSumAggregator.class);
            for (int i = 0; i < 100; ++i) {
                this.registerAggregator(AggregatorsTestComputation.ARRAY_PREFIX_AGG + i, LongSumAggregator.class);
            }
        }
    }
}

