/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsonorg;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.datatype.jsonorg.JSONArrayDeserializer;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONObjectDeserializer
extends StdDeserializer<JSONObject> {
    public static final JSONObjectDeserializer instance = new JSONObjectDeserializer();

    public JSONObjectDeserializer() {
        super(JSONObject.class);
    }

    public JSONObject deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JSONObject ob = new JSONObject();
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = jp.nextToken();
        }
        while (t == JsonToken.FIELD_NAME) {
            block15: {
                String fieldName = jp.getCurrentName();
                t = jp.nextToken();
                try {
                    switch (t) {
                        case START_ARRAY: {
                            ob.put(fieldName, (Object)JSONArrayDeserializer.instance.deserialize(jp, ctxt));
                            break block15;
                        }
                        case START_OBJECT: {
                            ob.put(fieldName, (Object)this.deserialize(jp, ctxt));
                            break block15;
                        }
                        case VALUE_STRING: {
                            ob.put(fieldName, (Object)jp.getText());
                            break block15;
                        }
                        case VALUE_NULL: {
                            ob.put(fieldName, JSONObject.NULL);
                            break block15;
                        }
                        case VALUE_TRUE: {
                            ob.put(fieldName, (Object)Boolean.TRUE);
                            break block15;
                        }
                        case VALUE_FALSE: {
                            ob.put(fieldName, (Object)Boolean.FALSE);
                            break block15;
                        }
                        case VALUE_NUMBER_INT: {
                            ob.put(fieldName, (Object)jp.getNumberValue());
                            break block15;
                        }
                        case VALUE_NUMBER_FLOAT: {
                            ob.put(fieldName, (Object)jp.getNumberValue());
                            break block15;
                        }
                        case VALUE_EMBEDDED_OBJECT: {
                            ob.put(fieldName, jp.getEmbeddedObject());
                            break block15;
                        }
                    }
                }
                catch (JSONException e) {
                    throw ctxt.mappingException("Failed to construct JSONObject: " + e.getMessage());
                }
                throw ctxt.mappingException("Urecognized or unsupported JsonToken type: " + t);
            }
            t = jp.nextToken();
        }
        return ob;
    }
}

