/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Ticker;
import io.airlift.stats.ExponentialDecay;
import io.airlift.stats.TimeDistribution;
import io.airlift.units.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class TimeStat {
    private final TimeDistribution oneMinute;
    private final TimeDistribution fiveMinutes;
    private final TimeDistribution fifteenMinutes;
    private final TimeDistribution allTime;
    private final Ticker ticker;

    public TimeStat() {
        this(Ticker.systemTicker(), TimeUnit.SECONDS);
    }

    public TimeStat(Ticker ticker) {
        this(ticker, TimeUnit.SECONDS);
    }

    public TimeStat(TimeUnit unit) {
        this(Ticker.systemTicker(), unit);
    }

    public TimeStat(Ticker ticker, TimeUnit unit) {
        this.ticker = ticker;
        this.oneMinute = new TimeDistribution(ExponentialDecay.oneMinute(), unit);
        this.fiveMinutes = new TimeDistribution(ExponentialDecay.fiveMinutes(), unit);
        this.fifteenMinutes = new TimeDistribution(ExponentialDecay.fifteenMinutes(), unit);
        this.allTime = new TimeDistribution(unit);
    }

    public void add(double value, TimeUnit timeUnit) {
        this.add(new Duration(value, timeUnit));
    }

    public void add(Duration duration) {
        this.add((long)duration.getValue(TimeUnit.NANOSECONDS));
    }

    private void add(long value) {
        this.oneMinute.add(value);
        this.fiveMinutes.add(value);
        this.fifteenMinutes.add(value);
        this.allTime.add(value);
    }

    public <T> T time(Callable<T> callable) throws Exception {
        long start = this.ticker.read();
        T result = callable.call();
        this.add(this.ticker.read() - start);
        return result;
    }

    public BlockTimer time() {
        return new BlockTimer();
    }

    @Managed
    @Nested
    public TimeDistribution getOneMinute() {
        return this.oneMinute;
    }

    @Managed
    @Nested
    public TimeDistribution getFiveMinutes() {
        return this.fiveMinutes;
    }

    @Managed
    @Nested
    public TimeDistribution getFifteenMinutes() {
        return this.fifteenMinutes;
    }

    @Managed
    @Nested
    public TimeDistribution getAllTime() {
        return this.allTime;
    }

    public TimeDistributionStatSnapshot snapshot() {
        return new TimeDistributionStatSnapshot(this.getOneMinute().snapshot(), this.getFiveMinutes().snapshot(), this.getFifteenMinutes().snapshot(), this.getAllTime().snapshot());
    }

    public static class TimeDistributionStatSnapshot {
        private final TimeDistribution.TimeDistributionSnapshot oneMinute;
        private final TimeDistribution.TimeDistributionSnapshot fiveMinute;
        private final TimeDistribution.TimeDistributionSnapshot fifteenMinute;
        private final TimeDistribution.TimeDistributionSnapshot allTime;

        @JsonCreator
        public TimeDistributionStatSnapshot(@JsonProperty(value="oneMinute") TimeDistribution.TimeDistributionSnapshot oneMinute, @JsonProperty(value="fiveMinute") TimeDistribution.TimeDistributionSnapshot fiveMinute, @JsonProperty(value="fifteenMinute") TimeDistribution.TimeDistributionSnapshot fifteenMinute, @JsonProperty(value="allTime") TimeDistribution.TimeDistributionSnapshot allTime) {
            this.oneMinute = oneMinute;
            this.fiveMinute = fiveMinute;
            this.fifteenMinute = fifteenMinute;
            this.allTime = allTime;
        }

        @JsonProperty
        public TimeDistribution.TimeDistributionSnapshot getOneMinute() {
            return this.oneMinute;
        }

        @JsonProperty
        public TimeDistribution.TimeDistributionSnapshot getFiveMinutes() {
            return this.fiveMinute;
        }

        @JsonProperty
        public TimeDistribution.TimeDistributionSnapshot getFifteenMinutes() {
            return this.fifteenMinute;
        }

        @JsonProperty
        public TimeDistribution.TimeDistributionSnapshot getAllTime() {
            return this.allTime;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("oneMinute", (Object)this.oneMinute).add("fiveMinute", (Object)this.fiveMinute).add("fifteenMinute", (Object)this.fifteenMinute).add("allTime", (Object)this.allTime).toString();
        }
    }

    public class BlockTimer
    implements AutoCloseable {
        private final long start;

        public BlockTimer() {
            this.start = TimeStat.this.ticker.read();
        }

        @Override
        public void close() {
            TimeStat.this.add(TimeStat.this.ticker.read() - this.start);
        }
    }
}

