/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import io.airlift.stats.DecayCounter;
import io.airlift.stats.QuantileDigest;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.weakref.jmx.Managed;

@ThreadSafe
public class Distribution {
    private static final double MAX_ERROR = 0.01;
    @GuardedBy(value="this")
    private final QuantileDigest digest;
    private final DecayCounter total;

    public Distribution() {
        this.digest = new QuantileDigest(0.01);
        this.total = new DecayCounter(0.0);
    }

    public Distribution(double alpha) {
        this.digest = new QuantileDigest(0.01, alpha);
        this.total = new DecayCounter(alpha);
    }

    public Distribution(Distribution distribution) {
        this.digest = new QuantileDigest(distribution.digest);
        this.total = new DecayCounter(distribution.digest.getAlpha());
        this.total.merge(distribution.total);
    }

    public synchronized void add(long value) {
        this.digest.add(value);
        this.total.add(value);
    }

    public synchronized void add(long value, long count) {
        this.digest.add(value, count);
        this.total.add(value * count);
    }

    @Managed
    public synchronized double getMaxError() {
        return this.digest.getConfidenceFactor();
    }

    @Managed
    public synchronized double getCount() {
        return this.digest.getCount();
    }

    @Managed
    public synchronized double getTotal() {
        return this.total.getCount();
    }

    @Managed
    public synchronized long getP01() {
        return this.digest.getQuantile(0.01);
    }

    @Managed
    public synchronized long getP05() {
        return this.digest.getQuantile(0.05);
    }

    @Managed
    public synchronized long getP10() {
        return this.digest.getQuantile(0.1);
    }

    @Managed
    public synchronized long getP25() {
        return this.digest.getQuantile(0.25);
    }

    @Managed
    public synchronized long getP50() {
        return this.digest.getQuantile(0.5);
    }

    @Managed
    public synchronized long getP75() {
        return this.digest.getQuantile(0.75);
    }

    @Managed
    public synchronized long getP90() {
        return this.digest.getQuantile(0.9);
    }

    @Managed
    public synchronized long getP95() {
        return this.digest.getQuantile(0.95);
    }

    @Managed
    public synchronized long getP99() {
        return this.digest.getQuantile(0.99);
    }

    @Managed
    public synchronized long getMin() {
        return this.digest.getMin();
    }

    @Managed
    public synchronized long getMax() {
        return this.digest.getMax();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public Map<Double, Long> getPercentiles() {
        List<Long> values;
        ArrayList<Double> percentiles = new ArrayList<Double>(100);
        for (int i = 0; i < 100; ++i) {
            percentiles.add((double)i / 100.0);
        }
        Distribution distribution = this;
        synchronized (distribution) {
            values = this.digest.getQuantiles(percentiles);
        }
        LinkedHashMap<Double, Long> result = new LinkedHashMap<Double, Long>(values.size());
        for (int i = 0; i < percentiles.size(); ++i) {
            result.put((Double)percentiles.get(i), values.get(i));
        }
        return result;
    }

    public synchronized List<Long> getPercentiles(List<Double> percentiles) {
        return this.digest.getQuantiles(percentiles);
    }

    public synchronized DistributionSnapshot snapshot() {
        List<Long> quantiles = this.digest.getQuantiles((List<Double>)ImmutableList.of((Object)0.01, (Object)0.05, (Object)0.1, (Object)0.25, (Object)0.5, (Object)0.75, (Object)0.9, (Object)0.95, (Object)0.99));
        return new DistributionSnapshot(this.getMaxError(), this.getCount(), this.getTotal(), quantiles.get(0), quantiles.get(1), quantiles.get(2), quantiles.get(3), quantiles.get(4), quantiles.get(5), quantiles.get(6), quantiles.get(7), quantiles.get(8), this.getMin(), this.getMax());
    }

    public static class DistributionSnapshot {
        private final double maxError;
        private final double count;
        private final double total;
        private final long p01;
        private final long p05;
        private final long p10;
        private final long p25;
        private final long p50;
        private final long p75;
        private final long p90;
        private final long p95;
        private final long p99;
        private final long min;
        private final long max;

        @JsonCreator
        public DistributionSnapshot(@JsonProperty(value="maxError") double maxError, @JsonProperty(value="count") double count, @JsonProperty(value="total") double total, @JsonProperty(value="p01") long p01, @JsonProperty(value="p05") long p05, @JsonProperty(value="p10") long p10, @JsonProperty(value="p25") long p25, @JsonProperty(value="p50") long p50, @JsonProperty(value="p75") long p75, @JsonProperty(value="p90") long p90, @JsonProperty(value="p95") long p95, @JsonProperty(value="p99") long p99, @JsonProperty(value="min") long min, @JsonProperty(value="max") long max) {
            this.maxError = maxError;
            this.count = count;
            this.total = total;
            this.p01 = p01;
            this.p05 = p05;
            this.p10 = p10;
            this.p25 = p25;
            this.p50 = p50;
            this.p75 = p75;
            this.p90 = p90;
            this.p95 = p95;
            this.p99 = p99;
            this.min = min;
            this.max = max;
        }

        @JsonProperty
        public double getMaxError() {
            return this.maxError;
        }

        @JsonProperty
        public double getCount() {
            return this.count;
        }

        @JsonProperty
        public double getTotal() {
            return this.total;
        }

        @JsonProperty
        public long getP01() {
            return this.p01;
        }

        @JsonProperty
        public long getP05() {
            return this.p05;
        }

        @JsonProperty
        public long getP10() {
            return this.p10;
        }

        @JsonProperty
        public long getP25() {
            return this.p25;
        }

        @JsonProperty
        public long getP50() {
            return this.p50;
        }

        @JsonProperty
        public long getP75() {
            return this.p75;
        }

        @JsonProperty
        public long getP90() {
            return this.p90;
        }

        @JsonProperty
        public long getP95() {
            return this.p95;
        }

        @JsonProperty
        public long getP99() {
            return this.p99;
        }

        @JsonProperty
        public long getMin() {
            return this.min;
        }

        @JsonProperty
        public long getMax() {
            return this.max;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("maxError", this.maxError).add("count", this.count).add("total", this.total).add("p01", this.p01).add("p05", this.p05).add("p10", this.p10).add("p25", this.p25).add("p50", this.p50).add("p75", this.p75).add("p90", this.p90).add("p95", this.p95).add("p99", this.p99).add("min", this.min).add("max", this.max).toString();
        }
    }
}

