/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.metadata.FieldKind;
import com.facebook.swift.codec.metadata.ThriftInjection;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ThriftFieldInjection
implements ThriftInjection {
    private final short id;
    private final String name;
    private final Field field;
    private final FieldKind fieldKind;

    public ThriftFieldInjection(short id, String name, Field field, FieldKind fieldKind) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.field = (Field)Preconditions.checkNotNull((Object)field, (Object)"field is null");
        this.fieldKind = (FieldKind)((Object)Preconditions.checkNotNull((Object)((Object)fieldKind), (Object)"fieldKind is null"));
        switch (fieldKind) {
            case THRIFT_FIELD: {
                Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0, (Object)"fieldId is negative");
                break;
            }
            case THRIFT_UNION_ID: {
                Preconditions.checkArgument((id == Short.MIN_VALUE ? 1 : 0) != 0, (Object)"fieldId must be Short.MIN_VALUE for thrift_union_id");
            }
        }
        this.id = id;
    }

    @Override
    public FieldKind getFieldKind() {
        return this.fieldKind;
    }

    @Override
    public short getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Field getField() {
        return this.field;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ThriftFieldInjection");
        sb.append("{fieldId=").append(this.id);
        sb.append(", name=").append(this.name);
        sb.append(", fieldKind=").append((Object)this.fieldKind);
        sb.append(", field=").append(this.field.getDeclaringClass().getSimpleName()).append(".").append(this.field.getName());
        sb.append('}');
        return sb.toString();
    }
}

