/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.internal.compiler.byteCode;

import com.facebook.swift.codec.internal.compiler.byteCode.Access;
import com.facebook.swift.codec.internal.compiler.byteCode.CaseStatement;
import com.facebook.swift.codec.internal.compiler.byteCode.FieldDefinition;
import com.facebook.swift.codec.internal.compiler.byteCode.LocalVariableDefinition;
import com.facebook.swift.codec.internal.compiler.byteCode.NamedParameterDefinition;
import com.facebook.swift.codec.internal.compiler.byteCode.ParameterizedType;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.concurrent.NotThreadSafe;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

@NotThreadSafe
public class MethodDefinition {
    private final EnumSet<Access> access;
    private final String name;
    private final ParameterizedType returnType;
    private final List<ParameterizedType> parameters;
    private final List<ParameterizedType> exceptions = new ArrayList<ParameterizedType>();
    private final InsnList instructionList = new InsnList();
    private final Map<String, LocalVariableDefinition> localVariables = new TreeMap<String, LocalVariableDefinition>();
    private final Map<String, Label> labels = new TreeMap<String, Label>();
    private int nextSlot;

    public MethodDefinition(EnumSet<Access> access, String name, ParameterizedType returnType, NamedParameterDefinition ... parameters) {
        this(access, name, returnType, (List<NamedParameterDefinition>)ImmutableList.copyOf((Object[])parameters));
    }

    public MethodDefinition(EnumSet<Access> access, String name, ParameterizedType returnType, List<NamedParameterDefinition> parameters) {
        this.access = access;
        this.name = name;
        this.returnType = returnType != null ? returnType : ParameterizedType.type(Void.TYPE);
        this.parameters = Lists.transform(parameters, NamedParameterDefinition.getNamedParameterType());
        if (!access.contains((Object)Access.STATIC)) {
            this.localVariables.put("this", new LocalVariableDefinition("this", 0, ParameterizedType.type(Object.class)));
            ++this.nextSlot;
        }
        int argId = 0;
        for (NamedParameterDefinition parameter : parameters) {
            String parameterName = parameter.getName();
            if (parameterName == null) {
                parameterName = "arg" + argId;
            }
            this.addLocalVariable(parameter.getType(), parameterName);
            ++argId;
        }
    }

    public MethodDefinition addException(Class<? extends Throwable> exceptionClass) {
        this.exceptions.add(ParameterizedType.type(exceptionClass));
        return this;
    }

    public LocalVariableDefinition addLocalVariable(ParameterizedType type, String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkArgument((!this.localVariables.containsKey(name) ? 1 : 0) != 0, (String)"There is already a local variable named %s", (Object[])new Object[]{name});
        LocalVariableDefinition variable = new LocalVariableDefinition(name, this.nextSlot, type);
        this.nextSlot += Type.getType((String)type.getType()).getSize();
        this.localVariables.put(name, variable);
        return variable;
    }

    public LocalVariableDefinition addInitializedLocalVariable(ParameterizedType type, String name) {
        LocalVariableDefinition variable = this.addLocalVariable(type, name);
        this.initializeLocalVariable(variable);
        return variable;
    }

    public LocalVariableDefinition getLocalVariable(String name) {
        LocalVariableDefinition localVariableDefinition = this.localVariables.get(name);
        Preconditions.checkArgument((localVariableDefinition != null ? 1 : 0) != 0, (String)"No local variable %s", (Object[])new Object[]{name});
        return localVariableDefinition;
    }

    public MethodDefinition visitLabel(String name) {
        this.instructionList.add((AbstractInsnNode)this.getLabel(name));
        return this;
    }

    public MethodDefinition gotoLabel(String name) {
        this.instructionList.add((AbstractInsnNode)new JumpInsnNode(167, this.getLabel(name)));
        return this;
    }

    public MethodDefinition ifZeroGoto(String name) {
        this.instructionList.add((AbstractInsnNode)new JumpInsnNode(153, this.getLabel(name)));
        return this;
    }

    public MethodDefinition ifNullGoto(String name) {
        this.instructionList.add((AbstractInsnNode)new JumpInsnNode(198, this.getLabel(name)));
        return this;
    }

    public MethodDefinition ifNotNullGoto(String name) {
        this.instructionList.add((AbstractInsnNode)new JumpInsnNode(199, this.getLabel(name)));
        return this;
    }

    private LabelNode getLabel(String name) {
        Label label = this.labels.get(name);
        if (label == null) {
            label = new Label();
            this.labels.put(name, label);
        }
        return new LabelNode(label);
    }

    public MethodDefinition switchStatement(String defaultCase, CaseStatement ... cases) {
        this.switchStatement(defaultCase, (List<CaseStatement>)ImmutableList.copyOf((Object[])cases));
        return this;
    }

    public MethodDefinition switchStatement(String defaultCase, List<CaseStatement> cases) {
        LabelNode defaultLabel = this.getLabel(defaultCase);
        int[] keys = new int[cases.size()];
        LabelNode[] labels = new LabelNode[cases.size()];
        for (int i = 0; i < cases.size(); ++i) {
            keys[i] = cases.get(i).getKey();
            labels[i] = this.getLabel(cases.get(i).getLabel());
        }
        this.instructionList.add((AbstractInsnNode)new LookupSwitchInsnNode(defaultLabel, keys, labels));
        return this;
    }

    public MethodNode getMethodNode() {
        MethodNode methodNode = new MethodNode();
        methodNode.access = Access.toAccessModifier(this.access);
        methodNode.name = this.name;
        methodNode.desc = MethodDefinition.methodDescription(this.returnType, this.parameters);
        if (this.returnType.isGeneric() || Iterables.any(this.parameters, ParameterizedType.isGenericType())) {
            methodNode.signature = MethodDefinition.genericMethodSignature(this.returnType, this.parameters);
        }
        methodNode.exceptions = new ArrayList();
        for (ParameterizedType exception : this.exceptions) {
            methodNode.exceptions.add(exception.getClassName());
        }
        methodNode.instructions.add(this.instructionList);
        return methodNode;
    }

    public static String methodDescription(Class<?> returnType, Class<?> ... parameterTypes) {
        return MethodDefinition.methodDescription(returnType, ImmutableList.copyOf((Object[])parameterTypes));
    }

    public static String methodDescription(Class<?> returnType, List<Class<?>> parameterTypes) {
        return MethodDefinition.methodDescription(ParameterizedType.type(returnType), Lists.transform(parameterTypes, ParameterizedType.toParameterizedType()));
    }

    public static String methodDescription(ParameterizedType returnType, ParameterizedType ... parameterTypes) {
        return MethodDefinition.methodDescription(returnType, (List<ParameterizedType>)ImmutableList.copyOf((Object[])parameterTypes));
    }

    public static String methodDescription(ParameterizedType returnType, List<ParameterizedType> parameterTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        Joiner.on((String)"").appendTo(sb, Iterables.transform(parameterTypes, ParameterizedType.getParameterType()));
        sb.append(")");
        sb.append(returnType.getType());
        return sb.toString();
    }

    public static String genericMethodSignature(ParameterizedType returnType, ParameterizedType ... parameterTypes) {
        return MethodDefinition.genericMethodSignature(returnType, (List<ParameterizedType>)ImmutableList.copyOf((Object[])parameterTypes));
    }

    public static String genericMethodSignature(ParameterizedType returnType, List<ParameterizedType> parameterTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        Joiner.on((String)"").appendTo(sb, parameterTypes);
        sb.append(")");
        sb.append(returnType);
        return sb.toString();
    }

    public MethodDefinition loadThis() {
        this.loadObject(0);
        return this;
    }

    public MethodDefinition loadObject(int slot) {
        this.instructionList.add((AbstractInsnNode)new VarInsnNode(25, slot));
        return this;
    }

    public MethodDefinition loadObject(int slot, ParameterizedType type) {
        this.loadObject(slot);
        this.checkCast(type);
        return this;
    }

    public MethodDefinition checkCast(ParameterizedType type) {
        this.instructionList.add((AbstractInsnNode)new TypeInsnNode(192, type.getClassName()));
        return this;
    }

    public MethodDefinition invokeConstructor(Constructor<?> constructor) {
        return this.invokeConstructor(constructor.getDeclaringClass(), constructor.getParameterTypes());
    }

    public MethodDefinition invokeConstructor(Class<?> type, Class<?> ... parameterTypes) {
        this.invokeConstructor(ParameterizedType.type(type), Lists.transform((List)ImmutableList.copyOf((Object[])parameterTypes), ParameterizedType.toParameterizedType()));
        return this;
    }

    public MethodDefinition invokeConstructor(ParameterizedType type, ParameterizedType ... parameterTypes) {
        this.invokeConstructor(type, (List<ParameterizedType>)ImmutableList.copyOf((Object[])parameterTypes));
        return this;
    }

    public MethodDefinition invokeConstructor(ParameterizedType type, List<ParameterizedType> parameterTypes) {
        this.invokeSpecial(type, "<init>", ParameterizedType.type(Void.TYPE), parameterTypes);
        return this;
    }

    public MethodDefinition invokeSpecial(ParameterizedType type, String name, ParameterizedType returnType, List<ParameterizedType> parameterTypes) {
        this.instructionList.add((AbstractInsnNode)new MethodInsnNode(183, type.getClassName(), name, MethodDefinition.methodDescription(returnType, parameterTypes)));
        return this;
    }

    public MethodDefinition invokeStatic(Method method) {
        this.instructionList.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(method.getDeclaringClass()), method.getName(), Type.getMethodDescriptor((Method)method)));
        return this;
    }

    public MethodDefinition invokeVirtual(Method method) {
        this.instructionList.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(method.getDeclaringClass()), method.getName(), Type.getMethodDescriptor((Method)method)));
        return this;
    }

    public MethodDefinition invokeVirtual(Class<?> type, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        this.instructionList.add((AbstractInsnNode)new MethodInsnNode(182, ParameterizedType.type(type).getClassName(), name, MethodDefinition.methodDescription(returnType, parameterTypes)));
        return this;
    }

    public MethodDefinition invokeVirtual(ParameterizedType type, String name, ParameterizedType returnType, ParameterizedType ... parameterTypes) {
        this.instructionList.add((AbstractInsnNode)new MethodInsnNode(182, type.getClassName(), name, MethodDefinition.methodDescription(returnType, parameterTypes)));
        return this;
    }

    public MethodDefinition ret() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(177));
        return this;
    }

    public MethodDefinition retObject() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(176));
        return this;
    }

    public MethodDefinition throwException() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(191));
        return this;
    }

    public MethodDefinition newObject(Class<?> type) {
        this.instructionList.add((AbstractInsnNode)new TypeInsnNode(187, ParameterizedType.type(type).getClassName()));
        return this;
    }

    public MethodDefinition newObject(ParameterizedType type) {
        this.instructionList.add((AbstractInsnNode)new TypeInsnNode(187, type.getClassName()));
        return this;
    }

    public MethodDefinition dup() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(89));
        return this;
    }

    public MethodDefinition pop() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(87));
        return this;
    }

    public MethodDefinition swap() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(95));
        return this;
    }

    public MethodDefinition getField(Field field) {
        return this.getField(field.getDeclaringClass(), field.getName(), field.getType());
    }

    public MethodDefinition getField(Class<?> target, FieldDefinition field) {
        this.getField(ParameterizedType.type(target), field.getName(), field.getType());
        return this;
    }

    public MethodDefinition getField(ParameterizedType target, FieldDefinition field) {
        this.getField(target, field.getName(), field.getType());
        return this;
    }

    public MethodDefinition getField(Class<?> target, String fieldName, Class<?> fieldType) {
        this.getField(ParameterizedType.type(target), fieldName, ParameterizedType.type(fieldType));
        return this;
    }

    public MethodDefinition getField(ParameterizedType target, String fieldName, ParameterizedType fieldType) {
        this.instructionList.add((AbstractInsnNode)new FieldInsnNode(180, target.getClassName(), fieldName, fieldType.getType()));
        return this;
    }

    public MethodDefinition getStaticField(ParameterizedType target, FieldDefinition field) {
        Preconditions.checkArgument((boolean)field.getAccess().contains((Object)Access.STATIC), (String)"Field is not static: %s", (Object[])new Object[]{field});
        this.getStaticField(target, field.getName(), field.getType());
        return this;
    }

    public MethodDefinition getStaticField(ParameterizedType target, String fieldName, ParameterizedType fieldType) {
        this.instructionList.add((AbstractInsnNode)new FieldInsnNode(178, target.getClassName(), fieldName, fieldType.getType()));
        return this;
    }

    public MethodDefinition putStaticField(ParameterizedType target, FieldDefinition field) {
        Preconditions.checkArgument((boolean)field.getAccess().contains((Object)Access.STATIC), (String)"Field is not static: %s", (Object[])new Object[]{field});
        this.putStaticField(target, field.getName(), field.getType());
        return this;
    }

    public MethodDefinition putStaticField(ParameterizedType target, String fieldName, ParameterizedType fieldType) {
        this.instructionList.add((AbstractInsnNode)new FieldInsnNode(179, target.getClassName(), fieldName, fieldType.getType()));
        return this;
    }

    public MethodDefinition putField(Field field) {
        return this.putField(field.getDeclaringClass(), field.getName(), field.getType());
    }

    public MethodDefinition putField(Class<?> target, FieldDefinition field) {
        return this.putField(ParameterizedType.type(target), field);
    }

    public MethodDefinition putField(Class<?> target, String fieldName, Class<?> fieldType) {
        this.putField(ParameterizedType.type(target), fieldName, ParameterizedType.type(fieldType));
        return this;
    }

    public MethodDefinition putField(ParameterizedType target, FieldDefinition field) {
        Preconditions.checkArgument((!field.getAccess().contains((Object)Access.STATIC) ? 1 : 0) != 0, (String)"Field is static: %s", (Object[])new Object[]{field});
        this.instructionList.add((AbstractInsnNode)new FieldInsnNode(181, target.getClassName(), field.getName(), field.getType().getType()));
        return this;
    }

    public MethodDefinition putField(ParameterizedType target, String fieldName, ParameterizedType fieldType) {
        this.instructionList.add((AbstractInsnNode)new FieldInsnNode(181, target.getClassName(), fieldName, fieldType.getType()));
        return this;
    }

    public MethodDefinition loadNull() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(1));
        return this;
    }

    public MethodDefinition addInstruction(AbstractInsnNode node) {
        this.instructionList.add(node);
        return this;
    }

    public MethodDefinition loadConstant(Class<?> type) {
        this.instructionList.add((AbstractInsnNode)new LdcInsnNode((Object)Type.getType(type)));
        return this;
    }

    public MethodDefinition loadConstant(ParameterizedType type) {
        this.instructionList.add((AbstractInsnNode)new LdcInsnNode((Object)Type.getType((String)type.getType())));
        return this;
    }

    public MethodDefinition loadConstant(String value) {
        this.instructionList.add((AbstractInsnNode)new LdcInsnNode((Object)value));
        return this;
    }

    public MethodDefinition loadConstant(int value) {
        switch (value) {
            case -1: {
                this.instructionList.add((AbstractInsnNode)new InsnNode(2));
                break;
            }
            case 0: {
                this.instructionList.add((AbstractInsnNode)new InsnNode(3));
                break;
            }
            case 1: {
                this.instructionList.add((AbstractInsnNode)new InsnNode(4));
                break;
            }
            case 2: {
                this.instructionList.add((AbstractInsnNode)new InsnNode(5));
                break;
            }
            case 3: {
                this.instructionList.add((AbstractInsnNode)new InsnNode(6));
                break;
            }
            case 4: {
                this.instructionList.add((AbstractInsnNode)new InsnNode(7));
                break;
            }
            case 5: {
                this.instructionList.add((AbstractInsnNode)new InsnNode(8));
                break;
            }
            default: {
                this.instructionList.add((AbstractInsnNode)new LdcInsnNode((Object)value));
            }
        }
        return this;
    }

    public MethodDefinition loadVariable(String name) {
        LocalVariableDefinition variable = this.localVariables.get(name);
        Preconditions.checkArgument((variable != null ? 1 : 0) != 0, (String)"unknown variable %s", (Object[])new Object[]{name});
        this.loadVariable(variable);
        return this;
    }

    public MethodDefinition loadVariable(String name, ParameterizedType type) {
        this.loadVariable(name);
        this.checkCast(type);
        return this;
    }

    public MethodDefinition initializeLocalVariable(LocalVariableDefinition variable) {
        ParameterizedType type = variable.getType();
        if (type.getType().length() == 1) {
            switch (type.getType().charAt(0)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    this.instructionList.add((AbstractInsnNode)new InsnNode(3));
                    break;
                }
                case 'F': {
                    this.instructionList.add((AbstractInsnNode)new InsnNode(11));
                    break;
                }
                case 'D': {
                    this.instructionList.add((AbstractInsnNode)new InsnNode(14));
                    break;
                }
                case 'J': {
                    this.instructionList.add((AbstractInsnNode)new InsnNode(9));
                    break;
                }
                default: {
                    Preconditions.checkArgument((boolean)false, (String)"Unknown type '%s'", (Object[])new Object[]{variable.getType()});
                    break;
                }
            }
        } else {
            this.instructionList.add((AbstractInsnNode)new InsnNode(1));
        }
        this.instructionList.add((AbstractInsnNode)new VarInsnNode(Type.getType((String)type.getType()).getOpcode(54), variable.getSlot()));
        return this;
    }

    public MethodDefinition loadVariable(LocalVariableDefinition variable) {
        ParameterizedType type = variable.getType();
        this.instructionList.add((AbstractInsnNode)new VarInsnNode(Type.getType((String)type.getType()).getOpcode(21), variable.getSlot()));
        return this;
    }

    public MethodDefinition storeVariable(String name) {
        LocalVariableDefinition variable = this.localVariables.get(name);
        Preconditions.checkArgument((variable != null ? 1 : 0) != 0, (Object)("unknown variable %s" + name));
        this.storeVariable(variable);
        return this;
    }

    public MethodDefinition storeVariable(LocalVariableDefinition variable) {
        ParameterizedType type = variable.getType();
        this.instructionList.add((AbstractInsnNode)new VarInsnNode(Type.getType((String)type.getType()).getOpcode(54), variable.getSlot()));
        return this;
    }
}

