/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.internal.compiler;

import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.codec.internal.ThriftCodecFactory;
import com.facebook.swift.codec.internal.compiler.DynamicClassLoader;
import com.facebook.swift.codec.internal.compiler.ThriftCodecByteCodeGenerator;
import com.facebook.swift.codec.metadata.ThriftStructMetadata;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CompilerThriftCodecFactory
implements ThriftCodecFactory {
    private final boolean debug;
    private final DynamicClassLoader classLoader;

    public CompilerThriftCodecFactory() {
        this(false);
    }

    public CompilerThriftCodecFactory(boolean debug) {
        this(debug, CompilerThriftCodecFactory.getPriviledgedClassLoader());
    }

    public CompilerThriftCodecFactory(boolean debug, DynamicClassLoader classLoader) {
        this.classLoader = classLoader;
        this.debug = debug;
    }

    @Override
    public ThriftCodec<?> generateThriftTypeCodec(ThriftCodecManager codecManager, ThriftStructMetadata metadata) {
        ThriftCodecByteCodeGenerator generator = new ThriftCodecByteCodeGenerator(codecManager, metadata, this.classLoader, this.debug);
        return generator.getThriftCodec();
    }

    private static DynamicClassLoader getPriviledgedClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<DynamicClassLoader>(){

            @Override
            public DynamicClassLoader run() {
                return new DynamicClassLoader();
            }
        });
    }
}

