/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.api;

import java.util.HashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class ProbesConfiguration {
    public static final int STATE_OFF = 0;
    public static final int STATE_ON = 1;
    @NotNull
    private final HashMap<String, Integer> myProbeClasses2State;

    public ProbesConfiguration() {
        this.myProbeClasses2State = new HashMap();
    }

    public ProbesConfiguration(@NotNull ProbesConfiguration second) {
        if (second == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myProbeClasses2State = new HashMap<String, Integer>(second.myProbeClasses2State);
    }

    public String[] getProbeClasses() {
        Set<String> probeClasses = this.myProbeClasses2State.keySet();
        return probeClasses.toArray(new String[probeClasses.size()]);
    }

    public boolean isEmpty() {
        return this.myProbeClasses2State.isEmpty();
    }

    public int getState(String probeClass) {
        Integer state = this.myProbeClasses2State.get(probeClass);
        return state != null ? state : 0;
    }

    public boolean isRegistered(String probeClass) {
        return this.getState(probeClass) != 0;
    }

    public void clear() {
        this.myProbeClasses2State.clear();
    }

    public void set(@NotNull String probeClass, int state) {
        if (probeClass == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myProbeClasses2State.put(probeClass, state);
    }

    @NotNull
    public static ProbesConfiguration getDifference(@NotNull ProbesConfiguration oldConfiguration, @NotNull ProbesConfiguration newConfiguration) {
        if (oldConfiguration == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (newConfiguration == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        ProbesConfiguration result = new ProbesConfiguration();
        for (String probeClass : newConfiguration.getProbeClasses()) {
            int newState;
            int oldState = oldConfiguration.getState(probeClass);
            if (oldState == (newState = newConfiguration.getState(probeClass))) continue;
            result.set(probeClass, newState);
        }
        ProbesConfiguration probesConfiguration = result;
        if (probesConfiguration == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return probesConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProbesConfiguration)) {
            return false;
        }
        ProbesConfiguration probesConfiguration = (ProbesConfiguration)o;
        return this.myProbeClasses2State.equals(probesConfiguration.myProbeClasses2State);
    }

    public int hashCode() {
        return this.myProbeClasses2State.hashCode();
    }
}

