/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.giraph.io.hcatalog.GiraphHCatInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hcatalog.common.ErrorType;
import org.apache.hcatalog.common.HCatException;
import org.apache.hcatalog.common.HCatUtil;
import org.apache.hcatalog.data.schema.HCatSchema;
import org.apache.hcatalog.mapreduce.HCatRecordReader;
import org.apache.hcatalog.mapreduce.HCatSplit;
import org.apache.hcatalog.mapreduce.HCatStorageHandler;
import org.apache.hcatalog.mapreduce.HCatTableInfo;
import org.apache.hcatalog.mapreduce.InputJobInfo;
import org.apache.hcatalog.mapreduce.InternalUtil;
import org.apache.hcatalog.mapreduce.PartInfo;
import org.apache.hcatalog.mapreduce.StorerInfo;
import org.apache.thrift.TException;

public class HCatUtils {
    private HCatUtils() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InputJobInfo getInputJobInfo(Configuration conf, InputJobInfo inputJobInfo) throws IOException {
        HiveMetaStoreClient client = null;
        try {
            HiveConf hiveConf = conf != null ? HCatUtil.getHiveConf((Configuration)conf) : new HiveConf(GiraphHCatInputFormat.class);
            client = HCatUtil.getHiveClient((HiveConf)hiveConf);
            Table table = HCatUtil.getTable((HiveMetaStoreClient)client, (String)inputJobInfo.getDatabaseName(), (String)inputJobInfo.getTableName());
            ArrayList<PartInfo> partInfoList = new ArrayList<PartInfo>();
            inputJobInfo.setTableInfo(HCatTableInfo.valueOf((org.apache.hadoop.hive.metastore.api.Table)table.getTTable()));
            if (table.getPartitionKeys().size() != 0) {
                List parts = client.listPartitionsByFilter(inputJobInfo.getDatabaseName(), inputJobInfo.getTableName(), inputJobInfo.getFilter(), (short)-1);
                if (parts != null) {
                    int maxPart = hiveConf.getInt("hcat.metastore.maxpartitions", 100000);
                    if (parts.size() > maxPart) {
                        throw new HCatException(ErrorType.ERROR_EXCEED_MAXPART, "total number of partitions is " + parts.size());
                    }
                    for (org.apache.hadoop.hive.metastore.api.Partition ptn : parts) {
                        HCatSchema schema = HCatUtil.extractSchema((Partition)new Partition(table, ptn));
                        PartInfo partInfo = HCatUtils.extractPartInfo(schema, ptn.getSd(), ptn.getParameters(), conf, inputJobInfo);
                        partInfo.setPartitionValues(InternalUtil.createPtnKeyValueMap((Table)table, (org.apache.hadoop.hive.metastore.api.Partition)ptn));
                        partInfoList.add(partInfo);
                    }
                }
            } else {
                HCatSchema schema = HCatUtil.extractSchema((Table)table);
                PartInfo partInfo = HCatUtils.extractPartInfo(schema, table.getTTable().getSd(), table.getParameters(), conf, inputJobInfo);
                partInfo.setPartitionValues(new HashMap());
                partInfoList.add(partInfo);
            }
            inputJobInfo.setPartitions(partInfoList);
        }
        catch (MetaException e) {
            try {
                throw new IOException("Got MetaException", e);
                catch (NoSuchObjectException e2) {
                    throw new IOException("Got NoSuchObjectException", e2);
                }
                catch (TException e3) {
                    throw new IOException("Got TException", e3);
                }
                catch (HiveException e4) {
                    throw new IOException("Got HiveException", e4);
                }
            }
            catch (Throwable throwable) {
                HCatUtil.closeHiveClientQuietly(client);
                throw throwable;
            }
        }
        HCatUtil.closeHiveClientQuietly((HiveMetaStoreClient)client);
        return inputJobInfo;
    }

    private static PartInfo extractPartInfo(HCatSchema schema, StorageDescriptor sd, Map<String, String> parameters, Configuration conf, InputJobInfo inputJobInfo) throws IOException {
        StorerInfo storerInfo = InternalUtil.extractStorerInfo((StorageDescriptor)sd, parameters);
        Properties hcatProperties = new Properties();
        HCatStorageHandler storageHandler = HCatUtil.getStorageHandler((Configuration)conf, (StorerInfo)storerInfo);
        Map jobProperties = HCatUtil.getInputJobProperties((HCatStorageHandler)storageHandler, (InputJobInfo)inputJobInfo);
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            hcatProperties.put(param.getKey(), param.getValue());
        }
        return new PartInfo(schema, storageHandler, sd.getLocation(), hcatProperties, jobProperties, inputJobInfo.getTableInfo());
    }

    public static RecordReader newHCatReader(HCatStorageHandler storageHandler, Map<String, String> valuesNotInDataCols) {
        return new HCatRecordReader(storageHandler, valuesNotInDataCols);
    }

    public static HCatSplit castToHCatSplit(InputSplit split) throws IOException {
        return InternalUtil.castToHCatSplit((InputSplit)split);
    }
}

