/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.hcatalog;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class HiveUtils {
    private HiveUtils() {
    }

    public static Map<String, String> parsePartitionValues(String outputTablePartitionString) {
        if (outputTablePartitionString == null) {
            return null;
        }
        Splitter commaSplitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        Splitter equalSplitter = Splitter.on((char)'=').omitEmptyStrings().trimResults();
        HashMap partitionValues = Maps.newHashMap();
        for (String keyValStr : commaSplitter.split((CharSequence)outputTablePartitionString)) {
            ArrayList keyVal = Lists.newArrayList((Iterable)equalSplitter.split((CharSequence)keyValStr));
            if (keyVal.size() != 2) {
                throw new IllegalArgumentException("Unrecognized partition value format: " + outputTablePartitionString);
            }
            partitionValues.put(keyVal.get(0), keyVal.get(1));
        }
        return partitionValues;
    }
}

