/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.hcatalog;

import java.io.IOException;
import java.util.List;
import org.apache.giraph.io.VertexValueInputFormat;
import org.apache.giraph.io.VertexValueReader;
import org.apache.giraph.io.hcatalog.GiraphHCatInputFormat;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hcatalog.data.HCatRecord;

public abstract class HCatalogVertexValueInputFormat<I extends WritableComparable, V extends Writable>
extends VertexValueInputFormat<I, V> {
    private GiraphHCatInputFormat hCatInputFormat = new GiraphHCatInputFormat();

    public List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        return this.hCatInputFormat.getVertexSplits(context);
    }

    protected abstract HCatalogVertexValueReader createVertexValueReader();

    public final VertexValueReader<I, V> createVertexValueReader(InputSplit split, TaskAttemptContext context) throws IOException {
        try {
            HCatalogVertexValueReader reader = this.createVertexValueReader();
            reader.initialize(split, context);
            return reader;
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("createVertexValueReader: Interrupted creating reader.", e);
        }
    }

    protected abstract class SingleRowHCatalogVertexValueReader
    extends HCatalogVertexValueReader {
        protected SingleRowHCatalogVertexValueReader() {
        }

        protected abstract I getVertexId(HCatRecord var1);

        protected abstract V getVertexValue(HCatRecord var1);

        public final I getCurrentVertexId() throws IOException, InterruptedException {
            return this.getVertexId((HCatRecord)this.getRecordReader().getCurrentValue());
        }

        public final V getCurrentVertexValue() throws IOException, InterruptedException {
            return this.getVertexValue((HCatRecord)this.getRecordReader().getCurrentValue());
        }
    }

    protected abstract class HCatalogVertexValueReader
    extends VertexValueReader<I, V> {
        private RecordReader<WritableComparable, HCatRecord> hCatRecordReader;
        private TaskAttemptContext context;

        protected HCatalogVertexValueReader() {
        }

        public final void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
            super.initialize(inputSplit, context);
            this.hCatRecordReader = HCatalogVertexValueInputFormat.this.hCatInputFormat.createVertexRecordReader(inputSplit, context);
            this.hCatRecordReader.initialize(inputSplit, context);
            this.context = context;
        }

        public boolean nextVertex() throws IOException, InterruptedException {
            return this.hCatRecordReader.nextKeyValue();
        }

        public final void close() throws IOException {
            this.hCatRecordReader.close();
        }

        public final float getProgress() throws IOException, InterruptedException {
            return this.hCatRecordReader.getProgress();
        }

        protected final RecordReader<WritableComparable, HCatRecord> getRecordReader() {
            return this.hCatRecordReader;
        }

        protected final TaskAttemptContext getContext() {
            return this.context;
        }
    }
}

