/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.hcatalog;

import java.io.IOException;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.VertexOutputFormat;
import org.apache.giraph.io.VertexWriter;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hcatalog.data.DefaultHCatRecord;
import org.apache.hcatalog.data.HCatRecord;
import org.apache.hcatalog.mapreduce.HCatOutputFormat;

public abstract class HCatalogVertexOutputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexOutputFormat<I, V, E> {
    protected HCatOutputFormat hCatOutputFormat = new HCatOutputFormat();

    public final void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        this.hCatOutputFormat.checkOutputSpecs(context);
    }

    public final OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return this.hCatOutputFormat.getOutputCommitter(context);
    }

    protected abstract HCatalogVertexWriter<I, V, E> createVertexWriter();

    public final VertexWriter<I, V, E> createVertexWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        HCatalogVertexWriter<I, V, E> writer = this.createVertexWriter();
        writer.initialize(this.hCatOutputFormat.getRecordWriter(context));
        return writer;
    }

    public static abstract class MultiRowHCatalogVertexWriter<I extends WritableComparable, V extends Writable, E extends Writable>
    extends HCatalogVertexWriter<I, V, E> {
        protected abstract Iterable<HCatRecord> createRecords(Vertex<I, V, E> var1);

        public final void writeVertex(Vertex<I, V, E> vertex) throws IOException, InterruptedException {
            Iterable<HCatRecord> records = this.createRecords(vertex);
            for (HCatRecord record : records) {
                this.getRecordWriter().write(null, (Object)record);
            }
        }
    }

    protected static abstract class SingleRowHCatalogVertexWriter<I extends WritableComparable, V extends Writable, E extends Writable>
    extends HCatalogVertexWriter<I, V, E> {
        protected SingleRowHCatalogVertexWriter() {
        }

        protected abstract int getNumColumns();

        protected abstract void fillRecord(HCatRecord var1, Vertex<I, V, E> var2);

        protected HCatRecord createRecord(Vertex<I, V, E> vertex) {
            DefaultHCatRecord record = new DefaultHCatRecord(this.getNumColumns());
            this.fillRecord((HCatRecord)record, vertex);
            return record;
        }

        public final void writeVertex(Vertex<I, V, E> vertex) throws IOException, InterruptedException {
            this.getRecordWriter().write(null, (Object)this.createRecord(vertex));
        }
    }

    protected static abstract class HCatalogVertexWriter<I extends WritableComparable, V extends Writable, E extends Writable>
    extends VertexWriter<I, V, E> {
        private RecordWriter<WritableComparable<?>, HCatRecord> hCatRecordWriter;
        private TaskAttemptContext context;

        protected HCatalogVertexWriter() {
        }

        protected void initialize(RecordWriter<WritableComparable<?>, HCatRecord> hCatRecordWriter) {
            this.hCatRecordWriter = hCatRecordWriter;
        }

        protected RecordWriter<WritableComparable<?>, HCatRecord> getRecordWriter() {
            return this.hCatRecordWriter;
        }

        protected TaskAttemptContext getContext() {
            return this.context;
        }

        public void initialize(TaskAttemptContext context) throws IOException {
            this.context = context;
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            this.hCatRecordWriter.close(context);
        }
    }
}

