/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.hcatalog;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.VertexInputFormat;
import org.apache.giraph.io.VertexReader;
import org.apache.giraph.io.hcatalog.GiraphHCatInputFormat;
import org.apache.giraph.utils.TimedLogger;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hcatalog.data.HCatRecord;
import org.apache.log4j.Logger;

public abstract class HCatalogVertexInputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexInputFormat<I, V, E> {
    private GiraphHCatInputFormat hCatInputFormat = new GiraphHCatInputFormat();

    public final List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        return this.hCatInputFormat.getVertexSplits(context);
    }

    protected abstract HCatalogVertexReader createVertexReader();

    public final VertexReader<I, V, E> createVertexReader(InputSplit split, TaskAttemptContext context) throws IOException {
        try {
            HCatalogVertexReader reader = this.createVertexReader();
            reader.initialize((RecordReader<WritableComparable, HCatRecord>)this.hCatInputFormat.createVertexRecordReader(split, context));
            return reader;
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("createVertexReader: Interrupted creating reader.", e);
        }
    }

    protected abstract class MultiRowHCatalogVertexReader
    extends HCatalogVertexReader {
        private static final int RECORD_MOD_LIMIT = 1000;
        private final Logger log;
        private I currentVertexId;
        private List<Edge<I, E>> currentEdges;
        private List<HCatRecord> recordsForVertex;
        private int recordCount;
        private Vertex<I, V, E> vertex;
        private final TimedLogger timedLogger;

        protected MultiRowHCatalogVertexReader() {
            this.log = Logger.getLogger(MultiRowHCatalogVertexReader.class);
            this.currentVertexId = null;
            this.currentEdges = Lists.newLinkedList();
            this.recordsForVertex = Lists.newArrayList();
            this.recordCount = 0;
            this.vertex = null;
            this.timedLogger = new TimedLogger(30000, this.log);
        }

        protected abstract I getVertexId(HCatRecord var1);

        protected abstract V getVertexValue(Iterable<HCatRecord> var1);

        protected abstract I getTargetVertexId(HCatRecord var1);

        protected abstract E getEdgeValue(HCatRecord var1);

        public final Vertex<I, V, E> getCurrentVertex() throws IOException, InterruptedException {
            return this.vertex;
        }

        @Override
        public boolean nextVertex() throws IOException, InterruptedException {
            while (this.getRecordReader().nextKeyValue()) {
                HCatRecord record = (HCatRecord)this.getRecordReader().getCurrentValue();
                if (this.currentVertexId == null) {
                    this.currentVertexId = this.getVertexId(record);
                }
                if (this.currentVertexId.equals(this.getVertexId(record))) {
                    this.currentEdges.add(EdgeFactory.create(this.getTargetVertexId(record), this.getEdgeValue(record)));
                    this.recordsForVertex.add(record);
                    continue;
                }
                this.createCurrentVertex();
                if (this.log.isInfoEnabled() && this.recordCount % 1000 == 0) {
                    this.timedLogger.info("read " + this.recordCount);
                }
                this.currentVertexId = this.getVertexId(record);
                this.recordsForVertex.add(record);
                return true;
            }
            if (this.currentEdges.isEmpty()) {
                return false;
            }
            this.createCurrentVertex();
            return true;
        }

        private void createCurrentVertex() {
            this.vertex = this.getConf().createVertex();
            this.vertex.initialize(this.currentVertexId, this.getVertexValue(this.recordsForVertex), this.currentEdges);
            this.currentEdges.clear();
            this.recordsForVertex.clear();
            ++this.recordCount;
        }
    }

    protected abstract class SingleRowHCatalogVertexReader
    extends HCatalogVertexReader {
        private static final int BYTE_CONST = 1024;
        private final Logger log;
        private int recordCount;
        private final int recordModLimit = 1000;
        private final TimedLogger timedLogger;

        protected SingleRowHCatalogVertexReader() {
            this.log = Logger.getLogger(SingleRowHCatalogVertexReader.class);
            this.recordCount = 0;
            this.recordModLimit = 1000;
            this.timedLogger = new TimedLogger(30000, this.log);
        }

        protected abstract I getVertexId(HCatRecord var1);

        protected abstract V getVertexValue(HCatRecord var1);

        protected abstract Iterable<Edge<I, E>> getEdges(HCatRecord var1);

        public final Vertex<I, V, E> getCurrentVertex() throws IOException, InterruptedException {
            HCatRecord record = (HCatRecord)this.getRecordReader().getCurrentValue();
            Vertex vertex = this.getConf().createVertex();
            vertex.initialize(this.getVertexId(record), this.getVertexValue(record), this.getEdges(record));
            ++this.recordCount;
            if (this.log.isInfoEnabled() && this.recordCount % 1000 == 0) {
                Runtime runtime = Runtime.getRuntime();
                double gb = 1.073741824E9;
                this.timedLogger.info("read " + this.recordCount + " records. Memory: " + (double)runtime.totalMemory() / gb + "GB total = " + (double)(runtime.totalMemory() - runtime.freeMemory()) / gb + "GB used + " + (double)runtime.freeMemory() / gb + "GB free, " + (double)runtime.maxMemory() / gb + "GB max");
            }
            return vertex;
        }
    }

    protected abstract class HCatalogVertexReader
    extends VertexReader<I, V, E> {
        private RecordReader<WritableComparable, HCatRecord> hCatRecordReader;
        private TaskAttemptContext context;

        protected HCatalogVertexReader() {
        }

        private void initialize(RecordReader<WritableComparable, HCatRecord> recordReader) {
            this.hCatRecordReader = recordReader;
        }

        public final void initialize(InputSplit inputSplit, TaskAttemptContext ctxt) throws IOException, InterruptedException {
            this.hCatRecordReader.initialize(inputSplit, ctxt);
            this.context = ctxt;
        }

        public boolean nextVertex() throws IOException, InterruptedException {
            return this.hCatRecordReader.nextKeyValue();
        }

        public final void close() throws IOException {
            this.hCatRecordReader.close();
        }

        public final float getProgress() throws IOException, InterruptedException {
            return this.hCatRecordReader.getProgress();
        }

        protected final RecordReader<WritableComparable, HCatRecord> getRecordReader() {
            return this.hCatRecordReader;
        }

        protected final TaskAttemptContext getContext() {
            return this.context;
        }
    }
}

