/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.hcatalog;

import java.io.IOException;
import java.util.List;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.io.EdgeInputFormat;
import org.apache.giraph.io.EdgeReader;
import org.apache.giraph.io.hcatalog.GiraphHCatInputFormat;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hcatalog.data.HCatRecord;

public abstract class HCatalogEdgeInputFormat<I extends WritableComparable, E extends Writable>
extends EdgeInputFormat<I, E> {
    private GiraphHCatInputFormat hCatInputFormat = new GiraphHCatInputFormat();

    public final List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        return this.hCatInputFormat.getEdgeSplits(context);
    }

    protected GiraphHCatInputFormat getHCatInputFormat() {
        return this.hCatInputFormat;
    }

    protected abstract HCatalogEdgeReader<I, E> createEdgeReader();

    public EdgeReader<I, E> createEdgeReader(InputSplit split, TaskAttemptContext context) throws IOException {
        try {
            HCatalogEdgeReader<I, E> reader = this.createEdgeReader();
            reader.initialize(split, context);
            return reader;
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("createEdgeReader: Interrupted creating reader.", e);
        }
    }

    protected static abstract class SingleRowHCatalogEdgeNoValueReader<I extends WritableComparable>
    extends HCatalogEdgeReader<I, NullWritable> {
        public SingleRowHCatalogEdgeNoValueReader(GiraphHCatInputFormat hCatInputFormat) {
            super(hCatInputFormat);
        }

        protected abstract I getSourceVertexId(HCatRecord var1);

        protected abstract I getTargetVertexId(HCatRecord var1);

        public I getCurrentSourceId() throws IOException, InterruptedException {
            HCatRecord record = (HCatRecord)this.getRecordReader().getCurrentValue();
            return this.getSourceVertexId(record);
        }

        public Edge<I, NullWritable> getCurrentEdge() throws IOException, InterruptedException {
            HCatRecord record = (HCatRecord)this.getRecordReader().getCurrentValue();
            return EdgeFactory.create(this.getTargetVertexId(record));
        }
    }

    protected static abstract class SingleRowHCatalogEdgeReader<I extends WritableComparable, E extends Writable>
    extends HCatalogEdgeReader<I, E> {
        public SingleRowHCatalogEdgeReader(GiraphHCatInputFormat hCatInputFormat) {
            super(hCatInputFormat);
        }

        protected abstract I getSourceVertexId(HCatRecord var1);

        protected abstract I getTargetVertexId(HCatRecord var1);

        protected abstract E getEdgeValue(HCatRecord var1);

        public I getCurrentSourceId() throws IOException, InterruptedException {
            HCatRecord record = (HCatRecord)this.getRecordReader().getCurrentValue();
            return this.getSourceVertexId(record);
        }

        public Edge<I, E> getCurrentEdge() throws IOException, InterruptedException {
            HCatRecord record = (HCatRecord)this.getRecordReader().getCurrentValue();
            return EdgeFactory.create(this.getTargetVertexId(record), this.getEdgeValue(record));
        }
    }

    protected static abstract class HCatalogEdgeReader<I extends WritableComparable, E extends Writable>
    extends EdgeReader<I, E> {
        private final GiraphHCatInputFormat hCatInputFormat;
        private RecordReader<WritableComparable, HCatRecord> hCatRecordReader;
        private TaskAttemptContext context;

        public HCatalogEdgeReader(GiraphHCatInputFormat hCatInputFormat) {
            this.hCatInputFormat = hCatInputFormat;
        }

        public final void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
            this.hCatRecordReader = this.hCatInputFormat.createEdgeRecordReader(inputSplit, context);
            this.hCatRecordReader.initialize(inputSplit, context);
            this.context = context;
        }

        public boolean nextEdge() throws IOException, InterruptedException {
            return this.hCatRecordReader.nextKeyValue();
        }

        public final void close() throws IOException {
            this.hCatRecordReader.close();
        }

        public final float getProgress() throws IOException, InterruptedException {
            return this.hCatRecordReader.getProgress();
        }

        protected final RecordReader<WritableComparable, HCatRecord> getRecordReader() {
            return this.hCatRecordReader;
        }

        protected final TaskAttemptContext getContext() {
            return this.context;
        }
    }
}

