/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.hcatalog;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.giraph.graph.Computation;
import org.apache.giraph.io.EdgeInputFormat;
import org.apache.giraph.io.VertexInputFormat;
import org.apache.giraph.io.VertexOutputFormat;
import org.apache.giraph.io.hcatalog.GiraphHCatInputFormat;
import org.apache.giraph.io.hcatalog.HCatalogEdgeInputFormat;
import org.apache.giraph.io.hcatalog.HCatalogVertexInputFormat;
import org.apache.giraph.io.hcatalog.HCatalogVertexOutputFormat;
import org.apache.giraph.io.hcatalog.HiveUtils;
import org.apache.giraph.job.GiraphJob;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hcatalog.data.schema.HCatSchema;
import org.apache.hcatalog.mapreduce.HCatOutputFormat;
import org.apache.hcatalog.mapreduce.InputJobInfo;
import org.apache.hcatalog.mapreduce.OutputJobInfo;
import org.apache.log4j.Logger;

public class HCatGiraphRunner
implements Tool {
    private static final Logger LOG = Logger.getLogger(HCatGiraphRunner.class);
    protected int workers;
    protected boolean isVerbose;
    protected Map<String, String> outputTablePartitionValues;
    protected String dbName;
    protected String vertexInputTableName;
    protected String vertexInputTableFilterExpr;
    protected String edgeInputTableName;
    protected String edgeInputTableFilterExpr;
    protected String outputTableName;
    private Configuration conf;
    private boolean skipOutput = false;
    private Class<? extends Computation> computationClass;
    private Class<? extends VertexInputFormat> vertexInputFormatClass;
    private Class<? extends EdgeInputFormat> edgeInputFormatClass;
    private Class<? extends VertexOutputFormat> vertexOutputFormatClass;

    protected HCatGiraphRunner(Class<? extends Computation> computationClass, Class<? extends VertexInputFormat> vertexInputFormatClass, Class<? extends EdgeInputFormat> edgeInputFormatClass, Class<? extends VertexOutputFormat> vertexOutputFormatClass) {
        this.computationClass = computationClass;
        this.vertexInputFormatClass = vertexInputFormatClass;
        this.edgeInputFormatClass = edgeInputFormatClass;
        this.vertexOutputFormatClass = vertexOutputFormatClass;
        this.conf = new HiveConf(this.getClass());
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Tool)new HCatGiraphRunner(null, null, null, null), (String[])args));
    }

    public final int run(String[] args) throws Exception {
        try {
            this.processArguments(args);
        }
        catch (InterruptedException e) {
            return 0;
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            return -1;
        }
        HCatGiraphRunner.adjustConfigurationForHive(this.getConf());
        GiraphJob job = new GiraphJob(this.getConf(), this.getClass().getName());
        job.getConfiguration().setComputationClass(this.computationClass);
        if (this.vertexInputFormatClass != null) {
            InputJobInfo vertexInputJobInfo = InputJobInfo.create((String)this.dbName, (String)this.vertexInputTableName, (String)this.vertexInputTableFilterExpr);
            GiraphHCatInputFormat.setVertexInput(job.getInternalJob(), vertexInputJobInfo);
            job.getConfiguration().setVertexInputFormatClass(this.vertexInputFormatClass);
        }
        if (this.edgeInputFormatClass != null) {
            InputJobInfo edgeInputJobInfo = InputJobInfo.create((String)this.dbName, (String)this.edgeInputTableName, (String)this.edgeInputTableFilterExpr);
            GiraphHCatInputFormat.setEdgeInput(job.getInternalJob(), edgeInputJobInfo);
            job.getConfiguration().setEdgeInputFormatClass(this.edgeInputFormatClass);
        }
        HCatOutputFormat.setOutput((Job)job.getInternalJob(), (OutputJobInfo)OutputJobInfo.create((String)this.dbName, (String)this.outputTableName, this.outputTablePartitionValues));
        HCatOutputFormat.setSchema((Job)job.getInternalJob(), (HCatSchema)HCatOutputFormat.getTableSchema((JobContext)job.getInternalJob()));
        if (this.skipOutput) {
            LOG.warn((Object)"run: Warning - Output will be skipped!");
        } else {
            job.getConfiguration().setVertexOutputFormatClass(this.vertexOutputFormatClass);
        }
        job.getConfiguration().setWorkerConfiguration(this.workers, this.workers, 100.0f);
        this.initGiraphJob(job);
        return job.run(this.isVerbose) ? 0 : -1;
    }

    private static void adjustConfigurationForHive(Configuration conf) {
        HCatGiraphRunner.addToStringCollection(conf, "tmpfiles", conf.getClassLoader().getResource("hive-site.xml").toString());
        String[] hadoopJars = System.getenv("HADOOP_CLASSPATH").split(File.pathSeparator);
        ArrayList hadoopJarURLs = Lists.newArrayList();
        for (String jarPath : hadoopJars) {
            File file = new File(jarPath);
            if (!file.exists() || !file.isFile()) continue;
            String jarURL = file.toURI().toString();
            hadoopJarURLs.add(jarURL);
        }
        HCatGiraphRunner.addToStringCollection(conf, "tmpjars", hadoopJarURLs);
    }

    private CommandLine processArguments(String[] args) throws ParseException, InterruptedException {
        Options options = new Options();
        options.addOption("h", "help", false, "Help");
        options.addOption("v", "verbose", false, "Verbose");
        options.addOption("D", "hiveconf", true, "property=value for Hive/Hadoop configuration");
        options.addOption("w", "workers", true, "Number of workers");
        if (this.computationClass == null) {
            options.addOption(null, "computationClass", true, "Giraph Computation class to use");
        }
        if (this.vertexInputFormatClass == null) {
            options.addOption(null, "vertexInputFormatClass", true, "Giraph HCatalogVertexInputFormat class to use");
        }
        if (this.edgeInputFormatClass == null) {
            options.addOption(null, "edgeInputFormatClass", true, "Giraph HCatalogEdgeInputFormat class to use");
        }
        if (this.vertexOutputFormatClass == null) {
            options.addOption(null, "vertexOutputFormatClass", true, "Giraph HCatalogVertexOutputFormat class to use");
        }
        options.addOption("db", "dbName", true, "Hive database name");
        options.addOption("vi", "vertexInputTable", true, "Vertex input table name");
        options.addOption("VI", "vertexInputFilter", true, "Vertex input table filter expression (e.g., \"a<2 AND b='two'\"");
        options.addOption("ei", "edgeInputTable", true, "Edge input table name");
        options.addOption("EI", "edgeInputFilter", true, "Edge input table filter expression (e.g., \"a<2 AND b='two'\"");
        options.addOption("o", "outputTable", true, "Output table name");
        options.addOption("O", "outputPartition", true, "Output table partition values (e.g., \"a=1,b=two\")");
        options.addOption("s", "skipOutput", false, "Skip output?");
        this.addMoreOptions(options);
        GnuParser parser = new GnuParser();
        CommandLine cmdln = parser.parse(options, args);
        if (args.length == 0 || cmdln.hasOption("help")) {
            new HelpFormatter().printHelp(this.getClass().getName(), options, true);
            throw new InterruptedException();
        }
        if (cmdln.hasOption("computationClass")) {
            this.computationClass = this.findClass(cmdln.getOptionValue("computationClass"), Computation.class);
        }
        if (cmdln.hasOption("vertexInputFormatClass")) {
            this.vertexInputFormatClass = this.findClass(cmdln.getOptionValue("vertexInputFormatClass"), HCatalogVertexInputFormat.class);
        }
        if (cmdln.hasOption("edgeInputFormatClass")) {
            this.edgeInputFormatClass = this.findClass(cmdln.getOptionValue("edgeInputFormatClass"), HCatalogEdgeInputFormat.class);
        }
        if (cmdln.hasOption("vertexOutputFormatClass")) {
            this.vertexOutputFormatClass = this.findClass(cmdln.getOptionValue("vertexOutputFormatClass"), HCatalogVertexOutputFormat.class);
        }
        if (cmdln.hasOption("skipOutput")) {
            this.skipOutput = true;
        }
        if (this.computationClass == null) {
            throw new IllegalArgumentException("Need the Giraph Computation class name (-computationClass) to use");
        }
        if (this.vertexInputFormatClass == null && this.edgeInputFormatClass == null) {
            throw new IllegalArgumentException("Need at least one of Giraph VertexInputFormat class name (-vertexInputFormatClass) and EdgeInputFormat class name (-edgeInputFormatClass)");
        }
        if (this.vertexOutputFormatClass == null) {
            throw new IllegalArgumentException("Need the Giraph VertexOutputFormat class name (-vertexOutputFormatClass) to use");
        }
        if (!cmdln.hasOption("workers")) {
            throw new IllegalArgumentException("Need to choose the number of workers (-w)");
        }
        if (!cmdln.hasOption("vertexInputTable") && this.vertexInputFormatClass != null) {
            throw new IllegalArgumentException("Need to set the vertex input table name (-vi)");
        }
        if (!cmdln.hasOption("edgeInputTable") && this.edgeInputFormatClass != null) {
            throw new IllegalArgumentException("Need to set the edge input table name (-ei)");
        }
        if (!cmdln.hasOption("outputTable")) {
            throw new IllegalArgumentException("Need to set the output table name (-o)");
        }
        this.dbName = cmdln.getOptionValue("dbName", "default");
        this.vertexInputTableName = cmdln.getOptionValue("vertexInputTable");
        this.vertexInputTableFilterExpr = cmdln.getOptionValue("vertexInputFilter");
        this.edgeInputTableName = cmdln.getOptionValue("edgeInputTable");
        this.edgeInputTableFilterExpr = cmdln.getOptionValue("edgeInputFilter");
        this.outputTableName = cmdln.getOptionValue("outputTable");
        this.outputTablePartitionValues = HiveUtils.parsePartitionValues(cmdln.getOptionValue("outputPartition"));
        this.workers = Integer.parseInt(cmdln.getOptionValue("workers"));
        this.isVerbose = cmdln.hasOption("verbose");
        for (String hiveconf : cmdln.getOptionValues("hiveconf")) {
            String[] keyval = hiveconf.split("=", 2);
            if (keyval.length != 2) continue;
            String name = keyval[0];
            String value = keyval[1];
            if (name.equals("tmpjars") || name.equals("tmpfiles")) {
                HCatGiraphRunner.addToStringCollection(this.conf, name, value);
                continue;
            }
            this.conf.set(name, value);
        }
        this.processMoreArguments(cmdln);
        return cmdln;
    }

    private static void addToStringCollection(Configuration conf, String name, String ... values) {
        HCatGiraphRunner.addToStringCollection(conf, name, Arrays.asList(values));
    }

    private static void addToStringCollection(Configuration conf, String name, Collection<? extends String> values) {
        Collection tmpfiles = conf.getStringCollection(name);
        tmpfiles.addAll(values);
        conf.setStrings(name, tmpfiles.toArray(new String[tmpfiles.size()]));
    }

    private <T> Class<? extends T> findClass(String className, Class<T> base) {
        try {
            Class<?> cls = Class.forName(className);
            if (base.isAssignableFrom(cls)) {
                return cls.asSubclass(base);
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(className + ": Invalid class name");
        }
    }

    public final Configuration getConf() {
        return this.conf;
    }

    public final void setConf(Configuration conf) {
        this.conf = conf;
    }

    protected void addMoreOptions(Options options) {
    }

    protected void processMoreArguments(CommandLine cmd) {
    }

    protected void initGiraphJob(GiraphJob job) {
        LOG.info((Object)(this.getClass().getSimpleName() + " with"));
        String prefix = "\t";
        LOG.info((Object)(prefix + "-computationClass=" + this.computationClass.getCanonicalName()));
        if (this.vertexInputFormatClass != null) {
            LOG.info((Object)(prefix + "-vertexInputFormatClass=" + this.vertexInputFormatClass.getCanonicalName()));
        }
        if (this.edgeInputFormatClass != null) {
            LOG.info((Object)(prefix + "-edgeInputFormatClass=" + this.edgeInputFormatClass.getCanonicalName()));
        }
        LOG.info((Object)(prefix + "-vertexOutputFormatClass=" + this.vertexOutputFormatClass.getCanonicalName()));
        if (this.vertexInputTableName != null) {
            LOG.info((Object)(prefix + "-vertexInputTable=" + this.vertexInputTableName));
        }
        if (this.vertexInputTableFilterExpr != null) {
            LOG.info((Object)(prefix + "-vertexInputFilter=\"" + this.vertexInputTableFilterExpr + "\""));
        }
        if (this.edgeInputTableName != null) {
            LOG.info((Object)(prefix + "-edgeInputTable=" + this.edgeInputTableName));
        }
        if (this.edgeInputTableFilterExpr != null) {
            LOG.info((Object)(prefix + "-edgeInputFilter=\"" + this.edgeInputTableFilterExpr + "\""));
        }
        LOG.info((Object)(prefix + "-outputTable=" + this.outputTableName));
        if (this.outputTablePartitionValues != null) {
            LOG.info((Object)(prefix + "-outputPartition=\"" + this.outputTablePartitionValues + "\""));
        }
        LOG.info((Object)(prefix + "-workers=" + this.workers));
    }
}

