/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.hcatalog;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.StringUtils;
import org.apache.hcatalog.common.HCatUtil;
import org.apache.hcatalog.data.HCatRecord;
import org.apache.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hcatalog.data.schema.HCatSchema;
import org.apache.hcatalog.mapreduce.HCatBaseInputFormat;
import org.apache.hcatalog.mapreduce.HCatSplit;
import org.apache.hcatalog.mapreduce.HCatStorageHandler;
import org.apache.hcatalog.mapreduce.HCatUtils;
import org.apache.hcatalog.mapreduce.InputJobInfo;
import org.apache.hcatalog.mapreduce.PartInfo;

public class GiraphHCatInputFormat
extends HCatBaseInputFormat {
    public static final String VERTEX_INPUT_JOB_INFO = "giraph.hcat.vertex.input.job.info";
    public static final String EDGE_INPUT_JOB_INFO = "giraph.hcat.edge.input.job.info";

    public static void setVertexInput(Job job, InputJobInfo inputJobInfo) throws IOException {
        InputJobInfo vertexInputJobInfo = InputJobInfo.create((String)inputJobInfo.getDatabaseName(), (String)inputJobInfo.getTableName(), (String)inputJobInfo.getFilter());
        vertexInputJobInfo.getProperties().putAll((Map<?, ?>)inputJobInfo.getProperties());
        Configuration conf = job.getConfiguration();
        conf.set(VERTEX_INPUT_JOB_INFO, HCatUtil.serialize((Serializable)HCatUtils.getInputJobInfo(conf, vertexInputJobInfo)));
    }

    public static void setEdgeInput(Job job, InputJobInfo inputJobInfo) throws IOException {
        InputJobInfo edgeInputJobInfo = InputJobInfo.create((String)inputJobInfo.getDatabaseName(), (String)inputJobInfo.getTableName(), (String)inputJobInfo.getFilter());
        edgeInputJobInfo.getProperties().putAll((Map<?, ?>)inputJobInfo.getProperties());
        Configuration conf = job.getConfiguration();
        conf.set(EDGE_INPUT_JOB_INFO, HCatUtil.serialize((Serializable)HCatUtils.getInputJobInfo(conf, edgeInputJobInfo)));
    }

    private static HCatSchema getTableSchema(InputJobInfo inputJobInfo) throws IOException {
        HCatSchema allCols = new HCatSchema(new LinkedList());
        for (HCatFieldSchema field : inputJobInfo.getTableInfo().getDataColumns().getFields()) {
            allCols.append(field);
        }
        for (HCatFieldSchema field : inputJobInfo.getTableInfo().getPartitionColumns().getFields()) {
            allCols.append(field);
        }
        return allCols;
    }

    public static HCatSchema getVertexTableSchema(Configuration conf) throws IOException {
        return GiraphHCatInputFormat.getTableSchema(GiraphHCatInputFormat.getVertexJobInfo(conf));
    }

    public static HCatSchema getEdgeTableSchema(Configuration conf) throws IOException {
        return GiraphHCatInputFormat.getTableSchema(GiraphHCatInputFormat.getEdgeJobInfo(conf));
    }

    private void setInputPath(JobConf jobConf, String location) throws IOException {
        int length = location.length();
        int curlyOpen = 0;
        int pathStart = 0;
        boolean globPattern = false;
        ArrayList<String> pathStrings = new ArrayList<String>();
        block5: for (int i = 0; i < length; ++i) {
            char ch = location.charAt(i);
            switch (ch) {
                case '{': {
                    ++curlyOpen;
                    if (globPattern) continue block5;
                    globPattern = true;
                    continue block5;
                }
                case '}': {
                    if (--curlyOpen != 0 || !globPattern) continue block5;
                    globPattern = false;
                    continue block5;
                }
                case ',': {
                    if (globPattern) continue block5;
                    pathStrings.add(location.substring(pathStart, i));
                    pathStart = i + 1;
                    continue block5;
                }
            }
        }
        pathStrings.add(location.substring(pathStart, length));
        Path[] paths = StringUtils.stringToPath((String[])pathStrings.toArray(new String[0]));
        FileSystem fs = FileSystem.get((Configuration)jobConf);
        Path path = paths[0].makeQualified(fs);
        StringBuilder str = new StringBuilder(StringUtils.escapeString((String)path.toString()));
        for (int i = 1; i < paths.length; ++i) {
            str.append(",");
            path = paths[i].makeQualified(fs);
            str.append(StringUtils.escapeString((String)path.toString()));
        }
        jobConf.set("mapred.input.dir", str.toString());
    }

    private List<InputSplit> getSplits(JobContext jobContext, InputJobInfo inputJobInfo) throws IOException, InterruptedException {
        Configuration conf = jobContext.getConfiguration();
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        List partitionInfoList = inputJobInfo.getPartitions();
        if (partitionInfoList == null) {
            return splits;
        }
        for (PartInfo partitionInfo : partitionInfoList) {
            org.apache.hadoop.mapred.InputSplit[] baseSplits;
            JobConf jobConf = HCatUtil.getJobConfFromContext((JobContext)jobContext);
            this.setInputPath(jobConf, partitionInfo.getLocation());
            Map jobProperties = partitionInfo.getJobProperties();
            HCatSchema allCols = new HCatSchema(new LinkedList());
            for (HCatFieldSchema field : inputJobInfo.getTableInfo().getDataColumns().getFields()) {
                allCols.append(field);
            }
            for (HCatFieldSchema field : inputJobInfo.getTableInfo().getPartitionColumns().getFields()) {
                allCols.append(field);
            }
            HCatUtil.copyJobPropertiesToJobConf((Map)jobProperties, (JobConf)jobConf);
            HCatStorageHandler storageHandler = HCatUtil.getStorageHandler((Configuration)jobConf, (PartInfo)partitionInfo);
            Class inputFormatClass = storageHandler.getInputFormatClass();
            InputFormat inputFormat = GiraphHCatInputFormat.getMapRedInputFormat((JobConf)jobConf, (Class)inputFormatClass);
            int desiredNumSplits = conf.getInt("hcat.desired.partition.num.splits", 0);
            for (org.apache.hadoop.mapred.InputSplit split : baseSplits = inputFormat.getSplits(jobConf, desiredNumSplits)) {
                splits.add((InputSplit)new HCatSplit(partitionInfo, split, allCols));
            }
        }
        return splits;
    }

    private static InputJobInfo getVertexJobInfo(Configuration conf) throws IOException {
        String jobString = conf.get(VERTEX_INPUT_JOB_INFO);
        if (jobString == null) {
            throw new IOException("Vertex job information not found in JobContext. GiraphHCatInputFormat.setVertexInput() not called?");
        }
        return (InputJobInfo)HCatUtil.deserialize((String)jobString);
    }

    private static InputJobInfo getEdgeJobInfo(Configuration conf) throws IOException {
        String jobString = conf.get(EDGE_INPUT_JOB_INFO);
        if (jobString == null) {
            throw new IOException("Edge job information not found in JobContext. GiraphHCatInputFormat.setEdgeInput() not called?");
        }
        return (InputJobInfo)HCatUtil.deserialize((String)jobString);
    }

    public List<InputSplit> getVertexSplits(JobContext jobContext) throws IOException, InterruptedException {
        return this.getSplits(jobContext, GiraphHCatInputFormat.getVertexJobInfo(jobContext.getConfiguration()));
    }

    public List<InputSplit> getEdgeSplits(JobContext jobContext) throws IOException, InterruptedException {
        return this.getSplits(jobContext, GiraphHCatInputFormat.getEdgeJobInfo(jobContext.getConfiguration()));
    }

    private RecordReader<WritableComparable, HCatRecord> createRecordReader(InputSplit split, HCatSchema schema, TaskAttemptContext taskContext) throws IOException, InterruptedException {
        HCatSplit hcatSplit = HCatUtils.castToHCatSplit(split);
        PartInfo partitionInfo = hcatSplit.getPartitionInfo();
        TaskAttemptContext jobContext = taskContext;
        Configuration conf = jobContext.getConfiguration();
        HCatStorageHandler storageHandler = HCatUtil.getStorageHandler((Configuration)conf, (PartInfo)partitionInfo);
        JobConf jobConf = HCatUtil.getJobConfFromContext((JobContext)jobContext);
        Map jobProperties = partitionInfo.getJobProperties();
        HCatUtil.copyJobPropertiesToJobConf((Map)jobProperties, (JobConf)jobConf);
        Map<String, String> valuesNotInDataCols = GiraphHCatInputFormat.getColValsNotInDataColumns(schema, partitionInfo);
        return HCatUtils.newHCatReader(storageHandler, valuesNotInDataCols);
    }

    public RecordReader<WritableComparable, HCatRecord> createVertexRecordReader(InputSplit split, TaskAttemptContext taskContext) throws IOException, InterruptedException {
        return this.createRecordReader(split, GiraphHCatInputFormat.getVertexTableSchema(taskContext.getConfiguration()), taskContext);
    }

    public RecordReader<WritableComparable, HCatRecord> createEdgeRecordReader(InputSplit split, TaskAttemptContext taskContext) throws IOException, InterruptedException {
        return this.createRecordReader(split, GiraphHCatInputFormat.getEdgeTableSchema(taskContext.getConfiguration()), taskContext);
    }

    private static Map<String, String> getColValsNotInDataColumns(HCatSchema outputSchema, PartInfo partInfo) {
        HCatSchema dataSchema = partInfo.getPartitionSchema();
        HashMap<String, String> vals = new HashMap<String, String>();
        for (String fieldName : outputSchema.getFieldNames()) {
            if (dataSchema.getPosition(fieldName) != null) continue;
            if (partInfo.getPartitionValues().containsKey(fieldName)) {
                vals.put(fieldName, (String)partInfo.getPartitionValues().get(fieldName));
                continue;
            }
            vals.put(fieldName, null);
        }
        return vals;
    }
}

